% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/info_add.R
\name{info_snippet}
\alias{info_snippet}
\title{Generate a useful text 'snippet' from the target table}
\usage{
info_snippet(x, snippet_name, fn)
}
\arguments{
\item{x}{An informant object of class \code{ptblank_informant}.}

\item{snippet_name}{The name for snippet, which is used for interpolating the
snippet itself into info text.}

\item{fn}{A function that obtains a snippet of data from the target table.}
}
\value{
A \code{ptblank_informant} object.
}
\description{
Getting little snippets of information from a table goes hand-in-hand with
mixing those bits of info with your table info. Call \code{info_snippet()} to
define a snippet and how you'll get that from the target table (it's with a
function). So long as you know how to interact with a table and extract
information, you can easily define snippets for a \emph{informant} object. And
once those snippets are defined, you can insert them into the info text as
defined through the \verb{info_*()} functions. Just use curly braces with the
\code{snippet_name} inside (e.g., \code{"This column has {n_cat} categories."}).
}
\section{Figures}{

\if{html}{\figure{man_info_snippet_1.png}{options: width=100\%}}
}

\section{Function ID}{

3-4
}

\examples{
# Take the `small_table` and
# assign it to `test_table`; we'll
# modify it later
test_table <- small_table

# Generate an informant object, add
# two snippets with `info_snippet()`,
# add information with some other
# `info_*()` functions and then
# `incorporate()` the snippets into
# the info text
informant <- 
  create_informant(
    read_fn = ~test_table,
    tbl_name = "test_table",
    label = "An example."
  ) \%>\%
  info_snippet(
    snippet_name = "row_count",
    fn = ~ . \%>\% nrow()
  ) \%>\%
  info_snippet(
    snippet_name = "col_count",
    fn = ~ . \%>\% ncol()
  ) \%>\%
  info_columns(
    columns = vars(a),
    info = "In the range of 1 to 10. (SIMPLE)"
  ) \%>\%
  info_columns(
    columns = starts_with("date"),
    info = "Time-based values (e.g., `Sys.time()`)."
  ) \%>\%
  info_columns(
    columns = "date",
    info = "The date part of `date_time`. (CALC)"
  ) \%>\%
  info_section(
    section_name = "rows",
    row_count = "There are {row_count} rows available."
  ) \%>\%
  incorporate()

# We can print the `informant` object
# to see the information report

# Let's modify `test_table` to give
# it more rows and an extra column
test_table <- 
  dplyr::bind_rows(test_table, test_table) \%>\%
  dplyr::mutate(h = a + c)

# Using `incorporate()` will cause
# the snippets to be reprocessed, and,
# the info text to be updated
informant <-
  informant \%>\% incorporate()
  
}
\seealso{
Other Information Functions: 
\code{\link{info_columns}()},
\code{\link{info_section}()},
\code{\link{info_tabular}()}
}
\concept{Information Functions}
