% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_decode}
\alias{ExprStr_decode}
\alias{expr_str_decode}
\title{decode}
\arguments{
\item{encoding}{string choice either 'hex' or 'base64'}

\item{...}{not used currently}

\item{strict}{Raise an error if the underlying value cannot be decoded,
otherwise mask out with a null value.}
}
\value{
Utf8 array with values decoded using provided encoding
}
\description{
Decode a value using the provided encoding.
}
\examples{
df = pl$DataFrame(strings = c("foo", "bar", NA))
df$select(pl$col("strings")$str$encode("hex"))
df$with_columns(
  pl$col("strings")$str$encode("base64")$alias("base64"), # notice DataType is not encoded
  pl$col("strings")$str$encode("hex")$alias("hex") # ... and must restored with cast
)$with_columns(
  pl$col("base64")$str$decode("base64")$alias("base64_decoded")$cast(pl$Utf8),
  pl$col("hex")$str$decode("hex")$alias("hex_decoded")$cast(pl$Utf8)
)
}
\keyword{ExprStr}
