% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__string.R
\name{ExprStr_split_exact}
\alias{ExprStr_split_exact}
\alias{expr_str_split_exact}
\title{split_exact}
\arguments{
\item{by}{Substring to split by.}

\item{n}{Number of splits to make.}

\item{inclusive}{If True, include the split_exact character/string in the results.}
}
\value{
Struct where each of n+1 fields is of Utf8 type
}
\description{
Split the string by a substring using \code{n} splits.
Results in a struct of \code{n+1} fields.
If it cannot make \code{n} splits, the remaining field elements will be null.
}
\examples{
df = pl$DataFrame(s = c("a_1", NA, "c", "d_4"))
df$select(pl$col("s")$str$split_exact(by = "_", 1))

}
\keyword{ExprStr}
