% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__expr.R
\name{Expr_fill_null}
\alias{Expr_fill_null}
\alias{fill_null}
\title{Fill Nulls with a value or strategy.}
\usage{
Expr_fill_null(value = NULL, strategy = NULL, limit = NULL)
}
\arguments{
\item{value}{Expr or \verb{Into<Expr>} to fill Null values with}

\item{strategy}{default NULL else 'forward', 'backward', 'min', 'max', 'mean', 'zero', 'one'}

\item{limit}{Number of consecutive null values to fill when using the 'forward' or 'backward' strategy.}
}
\value{
Expr
}
\description{
Shift the values by value or as strategy.
}
\details{
See Inf,NaN,NULL,Null/NA translations here \code{\link[polars]{docs_translations}}
}
\examples{
pl$select(
  pl$lit(0:3)$shift_and_fill(-2, fill_value = 42)$alias("shift-2"),
  pl$lit(0:3)$shift_and_fill(2, fill_value = pl$lit(42) / 2)$alias("shift+2")
)
}
\keyword{Expr}
