% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_sessions_config.R
\name{global_sessions_config}
\alias{global_sessions_config}
\title{Configuration for global sessions}
\usage{
global_sessions_config(
  app_name,
  api_key,
  firebase_config = NULL,
  admin_mode = FALSE,
  is_invite_required = TRUE,
  api_url = "https://api.polished.tech",
  sign_in_providers = "email",
  is_email_verification_required = TRUE
)
}
\arguments{
\item{app_name}{the name of the app.}

\item{api_key}{the API key. Either from polished.tech or your on premise polished API
deployment.}

\item{firebase_config}{a list containing your Firebase project configuration.  This list should have the
following named elements:
\itemize{
  \item{apiKey}
  \item{authDomain}
  \item{projectId}
}}

\item{admin_mode}{FALSE by default.  Set to TRUE to enter the polished Admin Panel without needing
to register and sign in.  This is useful during development for inviting the first users to your app.
Make sure to set `admin_mode` to FALSE before deploying your app.}

\item{is_invite_required}{TRUE by default.  Whether or not to require the user to have an
invite before registering/signing in}

\item{api_url}{the API url.  Defaults to "https://api.polished.tech".}

\item{sign_in_providers}{the sign in providers to enable.  Valid values are "google"
"email", "microsoft", and/or "facebook". Defaults to \code{"email"}.}

\item{is_email_verification_required}{TRUE by default.  Whether or not to require the user to
verify their email before accessing your Shiny app.}
}
\description{
This is the primary function for configuring 'polished'.  It configures your app's instance of the
\code{Sessions} class that manages your user's 'polished' sessions.  Call this function in
your "global.R" file.  See \url{https://github.com/Tychobra/polished/blob/master/inst/examples/polished_example_01/global.R}
for a complete example.
}
\examples{

\dontrun{
# global.R

global_sessions_config(
  app_name = "<your app name>",
  api_key = "<your API key>"
)

}

}
