% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blapply_method.R
\docType{methods}
\name{blapply}
\alias{blapply}
\alias{blapply,bundle-method}
\alias{blapply,list-method}
\title{apply a function over a list or bundle with and without verbose
parallelization}
\usage{
blapply(x, ...)

\S4method{blapply}{list}(x, f, mc = TRUE, progress = TRUE,
  verbose = FALSE, ...)

\S4method{blapply}{bundle}(x, f, mc = FALSE, progress = TRUE,
  verbose = FALSE, ...)
}
\arguments{
\item{x}{a list or a bundle object}

\item{...}{further parameters}

\item{f}{a function that can be applied to each object contained in the
bundle, note that it should swallow the parameters mc, verbose and progress
(use ... to catch these params )}

\item{mc}{logical, whether to use multicore - if TRUE, the number of cores
will be taken from the polmineR-options}

\item{progress}{logical, whether to display progress bar}

\item{verbose}{logical, whether to print intermediate messages}
}
\description{
apply a function over a list or bundle with and without verbose
parallelization
}
\examples{
if (require(polmineR.sampleCorpus) && require(rcqp)){
  use(polmineR.sampleCorpus)
  bt <- partition("PLPRBTTXT", list(text_id=".*"), regex=TRUE)
  speeches <- as.speeches(bt, sAttributeDates="text_date", sAttributeNames="text_name")
  foo <- blapply(speeches, function(x, ...) slot(x, "cpos"))
}
}

