% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/corpus.R
\docType{class}
\name{corpus-class}
\alias{corpus-class}
\alias{zoom}
\alias{$,corpus-method}
\alias{==,corpus,ANY-method}
\alias{!=,corpus,ANY-method}
\alias{\%in\%,corpus-method}
\alias{zoom,corpus-method}
\title{S4 class to wrap information on CWB corpora.}
\usage{
\S4method{$}{corpus}(x, name)

\S4method{==}{corpus,ANY}(e1, e2)

\S4method{!=}{corpus,ANY}(e1, e2)

\S4method{\%in\%}{corpus}(x, table)

\S4method{zoom}{corpus}(x, ...)
}
\arguments{
\item{x}{A \code{corpus} object.}

\item{name}{An s-attribute that will be assigned as key to a
\code{partition}.}

\item{e1}{A first expression, a \code{partition} object in this case.}

\item{e2}{A second expression, the value of an s-attribute.}

\item{table}{Values a s-attribute shall assume.}

\item{...}{Further arguments.}
}
\description{
S4 class to wrap information on CWB corpora.
}
\details{
The `$`-method will assign the argument \code{name} to the slot
  \code{key} and return the modified object.
}
\section{Slots}{

\describe{
\item{\code{corpus}}{A length-one \code{character} vector, a CWB corpus.}

\item{\code{data_dir}}{The directory where the files for the indexed corpus are.}

\item{\code{type}}{The type of the corpus (e.g. "plpr" for a corpus of plenary protocols).}

\item{\code{encoding}}{The encoding of the corpus, given as a length-one \code{character} vector.}

\item{\code{key}}{A length-one \code{character} vector stating a s-attribute that
serves as a key.}
}}

\examples{
corp <- corpus("GERMAPARLMINI")
corp2 <- corp$speaker
corp2@key
x <- corpus("GERMAPARLMINI")
x$date == "2009-10-28"
x <- corpus("GERMAPARLMINI")
x$party != "NA"
x <- corpus("GERMAPARLMINI")
x$date \%in\% c("2009-10-27", "2009-10-28")
x <- corpus("GERMAPARLMINI")
y <- zoom(x, date == "2009-10-28")

x <- partition("GERMAPARLMINI", interjection = "speech")
m <- zoom(x, date == "2009-10-28" & speaker == "Angela Dorothea Merkel")

not_unknown <- zoom(x, party != c("NA", "FDP"))
s_attributes(not_unknown, "party")
}
\seealso{
Other classes to manage corpora: \code{\link{regions}},
  \code{\link{subcorpus-class}}
}
\concept{classes to manage corpora}
