% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tooltips.R
\name{tooltips}
\alias{tooltips}
\alias{tooltips,character-method}
\alias{tooltips,html-method}
\alias{tooltips,kwic-method}
\title{Add tooltips to text output.}
\usage{
tooltips(.Object, tooltips, ...)

\S4method{tooltips}{character}(.Object, tooltips = list())

\S4method{tooltips}{html}(.Object, tooltips = list())

\S4method{tooltips}{kwic}(.Object, tooltips, regex = FALSE, ...)
}
\arguments{
\item{.Object}{A \code{html} or \code{character} object with html.}

\item{tooltips}{A named \code{list} of character vectors, the names need to
match colors in the list provided to param \code{highlight}. The value of
the character vector is the tooltip to be displayed.}

\item{...}{Further arguments are interpreted as assignments of tooltips to
tokens.}

\item{regex}{Logical, whether character vector values of argument
\code{tooltips} are interpreted as regular expressions.}
}
\description{
Highlight tokens based on exact match, a regular expression or corpus
position in \code{kwic} output or html document.
}
\examples{
use("polmineR")

P <- partition("REUTERS", places = "argentina")
H <- html(P)
Y <- highlight(H, lightgreen = "higher")
T <- tooltips(Y, list(lightgreen = "Further information"))
if (interactive()) T

# Using the tooltips-method in a pipe ...
h <- P \%>\%
  html() \%>\%
  highlight(yellow = c("barrels", "oil", "gas")) \%>\%
  tooltips(list(yellow = "energy"))
}
