% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpos.R
\name{cpos}
\alias{cpos}
\alias{cpos,corpus-method}
\alias{cpos,character-method}
\alias{cpos,slice-method}
\alias{cpos,partition-method}
\alias{cpos,subcorpus-method}
\alias{cpos,matrix-method}
\alias{cpos,hits-method}
\alias{cpos,NULL-method}
\title{Get corpus positions for a query or queries.}
\usage{
cpos(.Object, ...)

\S4method{cpos}{corpus}(
  .Object,
  query,
  p_attribute = getOption("polmineR.p_attribute"),
  cqp = is.cqp,
  regex = FALSE,
  check = TRUE,
  verbose = TRUE,
  ...
)

\S4method{cpos}{character}(
  .Object,
  query,
  p_attribute = getOption("polmineR.p_attribute"),
  cqp = is.cqp,
  check = TRUE,
  verbose = TRUE,
  ...
)

\S4method{cpos}{slice}(
  .Object,
  query,
  cqp = is.cqp,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  verbose = TRUE,
  ...
)

\S4method{cpos}{partition}(
  .Object,
  query,
  cqp = is.cqp,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  verbose = TRUE,
  ...
)

\S4method{cpos}{subcorpus}(
  .Object,
  query,
  cqp = is.cqp,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  verbose = TRUE,
  ...
)

\S4method{cpos}{matrix}(.Object)

\S4method{cpos}{hits}(.Object)

\S4method{cpos}{`NULL`}(.Object)
}
\arguments{
\item{.Object}{A length-one \code{character} vector indicating a CWB corpus, a
\code{partition} object, or a \code{matrix} with corpus positions.}

\item{...}{Used for reasons of backwards compatibility to
process arguments that have been renamed (e.g. \code{pAttribute}).}

\item{query}{A \code{character} vector providing one or multiple queries (token to
look up, regular expression or CQP query). Token ids (i.e. \code{integer}
values) are also accepted. If \code{query} is neither a regular expression nor a
CQP query, a sanity check removes accidental leading/trailing whitespace,
issuing a respective warning.}

\item{p_attribute}{The p-attribute to search. Needs to be stated only if query
is not a CQP query. Defaults to \code{NULL}.}

\item{cqp}{Either logical (\code{TRUE} if query is a CQP query), or a function to
check whether query is a CQP query or not (defaults to \code{is.cqp} auxiliary
function).}

\item{regex}{Interpret \code{query} as a regular expression.}

\item{check}{A \code{logical} value, whether to check validity of CQP query
using \code{check_cqp_query}.}

\item{verbose}{A \code{logical} value, whether to show messages.}
}
\value{
Unless \code{.Object} is a \code{matrix}, the return value is a
\code{matrix} with two columns.  The first column reports the left/starting
corpus positions (cpos) of the hits obtained. The second column reports the
right/ending corpus positions of the respective hit. The number of rows is
the number of hits. If there are no hits, a \code{NULL} object is returned.
}
\description{
Get matches for a query in a CQP corpus (subcorpus, partition etc.),
optionally using the CQP syntax of the Corpus Workbench (CWB).
}
\details{
If the \code{cpos()}-method is applied on a \code{character} or
\code{partition} object, the result is a two-column \code{matrix} with the
regions (start end end corpus positions of the matches) for a query. CQP
syntax can be used. The encoding of the query is adjusted to conform to the
encoding of the CWB corpus. If there are not matches, \code{NULL} is
returned.

If the \code{cpos()}-method is called on a \code{matrix} object,  the cpos
matrix is unfolded, the return value is an integer vector with the individual
corpus positions.

If \code{.Object} is a \code{hits} object, an \code{integer} vector is
returned with the individual corpus positions.

. If \code{.Object} is a \code{matrix}, it is assumed to be a region
matrix, i.e. a two-column \code{matrix} with left and right corpus positions
in the first and second row, respectively. For many operations, such as
decoding the token stream, it is necessary to inflate the denoted regions
into a vector of all corpus positions referred to by the regions defined in
the matrix. The \code{cpos}-method for \code{matrix} objects will performs
this task robustly.

If \code{.Object} is \code{NULL}, the method will return an empty
integer vector. Used internally to handle \code{NULL} objects that may be
returned from the \code{cpos}-method if no matches are obtained for a
query.
}
\examples{
use(pkg = "RcppCWB", corpus = "REUTERS")

# looking up single tokens
cpos("REUTERS", query = "oil")
corpus("REUTERS") \%>\% cpos(query = "oil")
corpus("REUTERS") \%>\% subset(grepl("saudi-arabia", places)) \%>\% cpos(query = "oil")
partition("REUTERS", places = "saudi-arabia", regex = TRUE) \%>\% cpos(query = "oil")

# using CQP query syntax
cpos("REUTERS", query = '"Saudi" "Arabia"')
corpus("REUTERS") \%>\% cpos(query = '"Saudi" "Arabia"')
corpus("REUTERS") \%>\%
  subset(grepl("saudi-arabia", places)) \%>\%
  cpos(query = '"Saudi" "Arabia"', cqp = TRUE)
partition("REUTERS", places = "saudi-arabia", regex = TRUE) \%>\%
  cpos(query = '"Saudi" "Arabia"', cqp = TRUE)
}
