% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{r_path_s1r}
\alias{r_path_s1r}
\alias{r_path_s2r}
\title{Samplers of one-dimensional modes of variation for polyspherical data}
\usage{
r_path_s1r(n, r, alpha = runif(r, -pi, pi), k = sample(-2:2, size = r,
  replace = TRUE), sigma = 0.25, angles = FALSE)

r_path_s2r(n, r, t = 0, c = 1, Theta = t(rotasym::r_unif_sphere(n = r, p
  = 3)), kappa = 0, sigma = 0.25, spiral = FALSE)
}
\arguments{
\item{n}{sample size.}

\item{r}{number of spheres in the polysphere \eqn{(\mathcal{S}^d)^r}.}

\item{alpha}{a vector of size \code{r} valued in \eqn{[-\pi,\pi)} with the
initial angles for the linear trend. Chosen at random by default.}

\item{k}{a vector of size \code{r} with the \bold{integer} slopes defining
the angular linear trend. Chosen at random by default.}

\item{sigma}{standard deviation of the noise about the one-dimensional mode
of variation. Defaults to \code{0.25}.}

\item{angles}{return angles in \eqn{[-\pi, \pi)}? Defaults to \code{FALSE}.}

\item{t}{latitude, with respect to \code{Theta}, of the small circle.
Defaults to \code{0} (equator).}

\item{c}{\href{https://en.wikipedia.org/wiki/Clélie}{Clélie curve}
parameter, changing the spiral wrappings. Defaults to \code{1}.}

\item{Theta}{a matrix of size \code{c(3, r)} giving the north poles for
\eqn{\mathcal{S}^2}. Useful for rotating the sample. Chosen at random by
default.}

\item{kappa}{concentration von Mises--Fisher parameter for longitudes in
small circles. Defaults to \code{0} (uniform).}

\item{spiral}{consider a spiral (or, more precisely, a
\href{https://en.wikipedia.org/wiki/Clélie}{Clélie curve}) instead of
a small circle? Defaults to \code{FALSE}.}
}
\value{
An array of size \code{c(n, d, r)} with samples on \eqn{(\mathcal{S}^d)^r}.
If \code{angles = TRUE} for \code{r_path_s1r}, then a matrix of size
\code{c(n ,r)} with angles is returned.
}
\description{
Functions for sampling data on \eqn{(\mathcal{S}^d)^r}, for
\eqn{d=1,2}, using one-dimensional modes of variation.
}
\examples{
# Straight trends on (S^1)^2
n <- 100
samp_1 <- r_path_s1r(n = n, r = 2, k = c(1, 2), angles = TRUE)
plot(samp_1, xlim = c(-pi, pi), ylim = c(-pi, pi), col = rainbow(n),
     axes = FALSE, xlab = "", ylab = "", pch = 16)
sdetorus::torusAxis()

# Straight trends on (S^1)^3
n <- 100
samp_2 <- r_path_s1r(n = n, r = 3, angles = TRUE)
pairs(samp_2, xlim = c(-pi, pi), ylim = c(-pi, pi), col = rainbow(n),
      pch = 16)
sdetorus::torusAxis()
scatterplot3d::scatterplot3d(
  samp_2, xlim = c(-pi, pi), ylim = c(-pi, pi), zlim = c(-pi, pi),
  xlab = "", ylab = "", zlab = "", color = rainbow(n), pch = 16
)

# Small-circle trends on (S^2)^2
n <- 100
samp_3 <- r_path_s2r(n = n, r = 2, sigma = 0.1, kappa = 5)
old_par <- par(mfrow = c(1, 2))
scatterplot3d::scatterplot3d(
  samp_3[, , 1], xlim = c(-1, 1), ylim = c(-1, 1), zlim = c(-1, 1),
  xlab = "", ylab = "", zlab = "", color = rainbow(n), pch = 16
)
scatterplot3d::scatterplot3d(
  samp_3[, , 2], xlim = c(-1, 1), ylim = c(-1, 1), zlim = c(-1, 1),
  xlab = "", ylab = "", zlab = "", color = rainbow(n), pch = 16
)
par(old_par)

# Spiral trends on (S^2)^2
n <- 100
samp_4 <- r_path_s2r(n = n, r = 2, c = 3, spiral = TRUE, sigma = 0.01)
old_par <- par(mfrow = c(1, 2))
scatterplot3d::scatterplot3d(
  samp_4[, , 1], xlim = c(-1, 1), ylim = c(-1, 1), zlim = c(-1, 1),
  xlab = "", ylab = "", zlab = "", color = rainbow(n), pch = 16
)
scatterplot3d::scatterplot3d(
  samp_4[, , 2], xlim = c(-1, 1), ylim = c(-1, 1), zlim = c(-1, 1),
  xlab = "", ylab = "", zlab = "", color = rainbow(n), pch = 16
)
par(old_par)
}
