% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kre.R
\name{bw_cv_kre_polysph}
\alias{bw_cv_kre_polysph}
\title{Cross-validation bandwidth selection for polyspherical-on-scalar
regression}
\usage{
bw_cv_kre_polysph(X, Y, d, p = 0, h_grid = bw.nrd(X) * 10^seq(-2, 2, l =
  100), plot_cv = TRUE, fast = TRUE)
}
\arguments{
\item{X}{a vector of size \code{n} with the predictor sample.}

\item{Y}{a matrix of size \code{c(n, sum(d) + r)} with the response sample
on the polysphere.}

\item{d}{vector of size \code{r} with dimensions.}

\item{p}{degree of local fit, either \code{0} or \code{1}. Defaults to
\code{0}.}

\item{h_grid}{bandwidth grid where to optimize the cross-validation loss.
Defaults to \code{bw.nrd(X) * 10^seq(-1, 1, l = 100)}.}

\item{plot_cv}{plot the cross-validation loss curve? Defaults to \code{TRUE}.}

\item{fast}{use the faster and equivalent version of the cross-validation
loss? Defaults to \code{TRUE}.}
}
\value{
A list with the following fields:
\item{h_min}{the bandwidth that minimizes the cross-validation loss.}
\item{h_1se}{the largest bandwidth within one standard error of the
minimal cross-validation loss.}
\item{cvm}{the mean of the cross-validation loss curve.}
\item{cvse}{the standard error of the cross-validation loss curve.}
}
\description{
Computes least squares cross-validation bandwidths for kernel
regression estimation with polyspherical response and scalar predictor.
It computes both the bandwidth that minimizes the cross-validation loss and
its "one standard error" variant.
}
\details{
A similar output to \code{glmnet}'s \code{\link[glmnet]{cv.glmnet}}
is returned.
}
\examples{
n <- 50
X <- seq(0, 1, l = n)
Y <- r_path_s2r(n = n, r = 1, sigma = 0.1, spiral = TRUE)[, , 1]
bw_cv_kre_polysph(X = X, Y = Y, d = 2, p = 0)
bw_cv_kre_polysph(X = X, Y = Y, d = 2, p = 1, fast = FALSE)
}
