% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{consensus_LG_assignment}
\alias{consensus_LG_assignment}
\title{Consensus LG assignment}
\usage{
consensus_LG_assignment(P1_assigned, P2_assigned, LG_number = 5, ploidy = 4,
  consensus_file = NULL, log = NULL)
}
\arguments{
\item{P1_assigned}{A marker assignment file of the first parent. Should contain the number of linkages per LG per marker.}

\item{P2_assigned}{A marker assignment file of the second parent. Should be the same markertype as first parent and contain the number of linkages per LG per marker.}

\item{LG_number}{Number of linkage groups (chromosomes).}

\item{ploidy}{Ploidy level of plant species.}

\item{consensus_file}{Filename of consensus output. No output is written if NULL.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
Returns a list containing the following components:
\item{P1_assigned}{
  A (modified) marker assignment matrix of the first parent.
}
\item{P2_assigned}{
  A (modified) marker assignment matrix of the second parent.
}
}
\description{
Assign markers to an LG based on consensus between two parents.
}
\examples{
data("P1_SxS_Assigned", "P2_SxS_Assigned_2")
SxS_Assigned_list <- consensus_LG_assignment(P1_SxS_Assigned, P2_SxS_Assigned_2, LG_number=5)
}
