% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{check_marker_assignment}
\alias{check_marker_assignment}
\title{Check for consistent marker assignment between both parents}
\usage{
check_marker_assignment(
  marker_assignment.P1,
  marker_assignment.P2,
  log = NULL,
  verbose = TRUE
)
}
\arguments{
\item{marker_assignment.P1}{A marker assignment matrix for parent 1 with markernames as rownames and at least containing the column \code{"Assigned_LG"}; the output of \code{\link{homologue_lg_assignment}}.}

\item{marker_assignment.P2}{A marker assignment matrix for parent 2 with markernames as rownames and at least containing the column \code{"Assigned_LG"}; the output of \code{\link{homologue_lg_assignment}}.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL (by default) log is send to stdout.}

\item{verbose}{Should messages be sent to stdout or log?}
}
\value{
Returns a list of matrices with corrected marker assignments.
}
\description{
Function to ensure there is consistent marker assignment to chromosomal linkage groups
for biparental markers
}
\examples{
data("marker_assignments_P1"); data("marker_assignments_P2")
check_marker_assignment(marker_assignments_P1,marker_assignments_P2)
}
