% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{plot_linkage_df}
\alias{plot_linkage_df}
\title{Plot r versus LOD grouped by phase}
\usage{
plot_linkage_df(
  linkage_df,
  r_max = 0.5,
  stepsize = 0.001,
  add_legend = TRUE,
  ...
)
}
\arguments{
\item{linkage_df}{A linkage data.frame as output of \code{\link{linkage}}.}

\item{r_max}{Maximum r value to plot}

\item{stepsize}{Size of window in recombination frequency to generate mean LOD score. Larger values will reduce plot density.}

\item{add_legend}{Logical, should a legend be added to the plot?}

\item{\dots}{Arguments passed to base plot function}
}
\description{
\code{plot_linkage_df} plots r versus LOD, colour separated for different phases.
}
\examples{
data("SN_SN_P1")
plot_linkage_df(SN_SN_P1)
}
