% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{screen_for_duplicate_individuals}
\alias{screen_for_duplicate_individuals}
\title{Screen for duplicate individuals}
\usage{
screen_for_duplicate_individuals(
  dosage_matrix,
  cutoff = NULL,
  plot_cor = T,
  log = NULL
)
}
\arguments{
\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{cutoff}{Correlation coefficient cut off. At this correlation coefficient, individuals are merged. If NULL user input will be asked after plotting.}

\item{plot_cor}{Logical. Should correlation coefficients be plotted? Can be memory/CPU intensive with high number of individuals.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}
}
\value{
A matrix similar to dosage_matrix, with merged duplicate individuals.
}
\description{
\code{screen_for_duplicate_individuals} identifies and merges duplicate individuals.
}
\examples{
\dontrun{
#user input:
data("segregating_data")
screen_for_duplicate_individuals(dosage_matrix=segregating_data,cutoff=0.9,plot_cor=TRUE)
}
}
