% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{import_IBD}
\alias{import_IBD}
\title{Import IBD probabilities as estimated by TetraOrigin}
\usage{
import_IBD(
  folder = NULL,
  filename.vec,
  bivalent_decoding = TRUE,
  error = 0.01,
  log = NULL
)
}
\arguments{
\item{folder}{The path to the folder in which the TetraOrigin output is contained, default is \code{NULL} if files are in working directory.}

\item{filename.vec}{A vector of the character filename(s) of the \code{.csv} file(s) containing the output of TetraOrigin. Should be in order according to LG/chromosome numbering.}

\item{bivalent_decoding}{Logical, if \code{TRUE} then only bivalent pairing was allowed in TetraOrigin,
specify \code{FALSE} if multivalent pairing was also allowed.}

\item{error}{The offspring error prior used in the offspring decoding step, here assumed to be 0.01}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\value{
Returns a list with the following items:
\item{IBDtype : }{Always "genotypeIBD" for the output of TetraOrigin}
\item{IBDarray : }{An array of IBD probabilities. The dimensions of the array are: markers, genotype classes and individuals.}
\item{map : }{Integrated linkage map positions of markers used in IBD calculation}
\item{parental_phase : }{The parental marker phasing as used by TetraOrigin, recoded in 1 and 0's}
\item{marginal.likelihoods : }{A list of marginal likelihoods of different valencies, currently \code{NULL}}
\item{valency : }{The predicted valency that maximised the marginal likelihood, per offspring. Currently \code{NULL}}
\item{offspring : }{Offspring names}
\item{biv_dec : }{Logical, the bivalent_decoding parameter specified.}
\item{gap : }{The gap size used in IBD interpolation, by default \code{NULL}. See \code{\link{spline_IBD}}}
\item{genocodes : }{Ordered list of genotype codes used to represent different genotype classes.}
\item{pairing : }{log likelihoods of each of the different pairing scenarios considered (can be used e.g. for post-mapping check of preferential pairing)}
\item{ploidy : }{The ploidy of parent 1, by default assumed to be 4}
\item{ploidy2 : }{The ploidy of parent 2, by default assumed to be 4}
\item{method : }{The method used, always returned as "hmm_TO" (Hidden Markov Model TetraOrigin)}
\item{error : }{The error prior used in the calculation, assumed to be 0.01}
}
\description{
Imports the summarised IBD probability output of TetraOrigin (which estimates IBD probabilities at all
marker positions), and interpolates these at a grid of positions at user-defined spacing.
}
