% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{plotQTL}
\alias{plotQTL}
\title{Plot the results of a previous QTL analysis}
\usage{
plotQTL(
  LOD_data,
  support_interval = 0,
  ylimits = NULL,
  multiplot = NULL,
  plot_type = "lines",
  overlay = FALSE,
  add_xaxis = TRUE,
  add_rug = TRUE,
  mainTitle = FALSE,
  log = NULL,
  ...
)
}
\arguments{
\item{LOD_data}{Output list from \code{\link{QTLscan}} with items QTL.res and Perm.res (the latter can be \code{NULL})}

\item{support_interval}{Numeric. If 0 (by default) then there is no support interval returned. If greater than zero,
then a LOD support interval is shown on output plot and the bounds are returned.}

\item{ylimits}{Use to specify ylimits of plot region, though by default \code{NULL} in which case a suitable plot region is automatically used.}

\item{multiplot}{Vector of integers. By default \code{NULL}. If \code{LOD_data} contains results from multiple linkage groups, you can
define the number of rows and columns in the plot layout.}

\item{plot_type}{How should be plots be drawn, either "lines" or "points" are possible}

\item{overlay}{Add to an existing plot (should be produced by a comparable call to this function) or not? By default \code{FALSE},
in which case a new plot is drawn. Can be useful for displaying results of multiple analyses together.}

\item{add_xaxis}{Should an x-axis be drawn? If multiple QTL analyses are performed on different traits, specifying this to be \code{FALSE}
and using \code{par(mar=c(0,4.1,4.1,2.1))} allows subsequent plots to be neatly stacked.}

\item{add_rug}{Logical, by default \code{TRUE} - should original marker points be added to plot?}

\item{mainTitle}{Vector of plot titles (single character vector also allowed and will be recycled). For no plot titles, leave as \code{FALSE}}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}

\item{\dots}{Extra arguments passed to plotting functions (plot, lines / points)}
}
\value{
The cM bounds of the LOD support interval, if \code{support_interval} > 0.
}
\description{
Basic QTL plotting function, taking map positions and significance levels as input
}
\examples{
data("qtl_LODs.4x")
plotQTL(LOD_data = qtl_LODs.4x,multiplot = c(1,2),ylimits = c(0,5), plot_type = "points")
}
