% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{plotRecLS}
\alias{plotRecLS}
\title{Plot the recombination landscape across the genome}
\usage{
plotRecLS(
  recombination_data,
  plot_per_LG = TRUE,
  plot_per_ind = TRUE,
  gap = 1,
  ...
)
}
\arguments{
\item{recombination_data}{Data on predicted recombination events, as returned by the function \code{\link{count_recombinations}}}

\item{plot_per_LG}{Logical argument, plot recombination events per linkage group? By default \code{TRUE}.}

\item{plot_per_ind}{Logical argument, plot recombination events per individual? By default \code{TRUE}.}

\item{gap}{The size (in cM) of the gap used to define the grid of positions to define the window in which to estimate 
recombination rate. By default 1 cM. Interpolated positions are taken to be the centre of an interval, so a 1 cM gap would
result in predictions for positions 0.5 cM, 1.5 cM etc.}

\item{\dots}{Option to pass extra arguments to the \code{\link{plot}} function for the per_LG plots. This may lead
to conflicts with arguments already declared internally (such as \code{main} for example).}
}
\value{
A list with two elements, \code{per_LG} and \code{per_individual}. The first of these is itself a list with the same length as \code{recombination_data}, giving the estimated recombination rates along the linkage group.
This rate is simply estimated as the (weighted) count of recombination breakpoints divided by the population size.
}
\description{
Function which visualises the recombination landscape in two ways: per linkage group, and per individual. 
For the first analysis, a rudimentary spline is also fitted to estimate the recombination rate along a grid of positions defined by \code{gap},
which is also returned by the function.
}
\examples{
data("Rec_Data_4x")
plotRecLS(Rec_Data_4x)
}
