% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pop_Gen_Functions.R
\name{GST}
\alias{GST}
\title{Nei's GST}
\usage{
GST(J = matrix, pairwise = TRUE)
}
\arguments{
\item{J}{A square matrix representing a gene identity matrix.}

\item{pairwise}{Logical indicating whether to calculate pairwise GST. If set
to FALSE, must not contain any missing data.}
}
\value{
If pairwise = TRUE, returns a matrix of pairwise GST values.
If pairwise = FALSE, returns the overall GST value.
}
\description{
This function calculates GST (Nei's standard genetic distance) measure from
a gene identity matrix.
}
\examples{
gene_identity_matrix <- matrix(c(
0.3164550, 0.2836333, 0.2760485,
0.2836333, 0.3106084, 0.2867215,
0.2760485, 0.2867215, 0.3338663
), nrow = 3, byrow = TRUE,
dimnames = list(paste0("Sample", 1:3), paste0("Sample", 1:3)))

GST(J=gene_identity_matrix, pairwise=TRUE)
GST(J=gene_identity_matrix, pairwise=FALSE)
}
