% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcf2pooldata.R
\name{vcf2pooldata}
\alias{vcf2pooldata}
\title{Convert a VCF file into a pooldata object.}
\usage{
vcf2pooldata(vcf.file = "", poolsizes = NA, poolnames = NA,
  min.cov.per.pool = -1, max.cov.per.pool = 1e+06, min.maf = 0.01,
  nlines.per.readblock = 1e+06)
}
\arguments{
\item{vcf.file}{The name (or a path) of the Popoolation sync file (might be in compressed format)}

\item{poolsizes}{A numeric vector with haploid pool sizes}

\item{poolnames}{A character vector with the names of pool}

\item{min.cov.per.pool}{Minimal allowed read count (per pool). If at least one pool is not covered by at least min.cov.perpool reads, the position is discarded}

\item{max.cov.per.pool}{Maximal allowed read count (per pool). If at least one pool is covered by more than min.cov.perpool reads, the position is discarded}

\item{min.maf}{Minimal allowed Minor Allele Frequency (computed from the ratio overal read counts for the reference allele over the read coverage)}

\item{nlines.per.readblock}{Number of Lines read simultaneously. Should be adapted to the available RAM.}
}
\value{
A pooldata object containing 7 elements:
\enumerate{
\item "refallele.readcount": a matrix with nsnp rows and npools columns containing read counts for the reference allele (chosen arbitrarily) in each pool
\item "readcoverage": a matrix with nsnp rows and npools columns containing read coverage in each pool
\item "snp.info": a matrix with nsnp rows and four columns containing respectively the contig (or chromosome) name (1st column) and position (2nd column) of the SNP; the allele in the reference assembly (3rd column); the allele taken as reference in the refallele matrix.readcount matrix (4th column); and the alternative allele (5th column)
\item "poolsizes": a vector of length npools containing the haploid pool sizes
\item "poolnames": a vector of length npools containing the names of the pools
\item "nsnp": a scalar corresponding to the number of SNPs
\item "npools": a scalar corresponding to the number of pools
}
}
\description{
Convert VCF files into a pooldata object. Only bi-allelic SNP are here considered.
}
\details{
This function has been more specifically developped to deal with VCF files obtained with the VarScan mpileup2snp program (when run with the --output-vcf option). Filtering of SNPs is assumed to have been done mostly with the caller. For instance, the behavior of the VarScan option --min-reads2 might be similar to that of the min_rc option in the popsync2pooldata function. Yet, SNP where the two major alleles in the Pool-Seq data are different from the reference allele will here be disregarded (this might be problematic in some applications, e.g., when using a distantly related reference genome for mapping).
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=vcf2pooldata(vcf.file=paste0(tempdir(),"/ex.vcf.gz"),poolsizes=rep(50,15))
}
