% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pooldata2genoselestim.R
\name{pooldata2genoselestim}
\alias{pooldata2genoselestim}
\title{Convert a pooldata object into SelEstim input files.}
\usage{
pooldata2genoselestim(pooldata, writing.dir = getwd(), prefix = "",
  subsamplesize = -1, subsamplingmethod = "thinning")
}
\arguments{
\item{pooldata}{A pooldata object containing Pool-Seq information (see \code{\link{vcf2pooldata}} and \code{\link{popsync2pooldata}})}

\item{writing.dir}{Directory where to create the files  (e.g., set writing.dir=getwd() to copy in the current working directory)}

\item{prefix}{Prefix used for output file names}

\item{subsamplesize}{Size of the sub-samples. If <=1 (default), all the SNPs are considered in the output}

\item{subsamplingmethod}{If sub-sampling is activated (argument subsamplesize), define the method used for subsampling that might be either i) "random" (A single data set consisting of randmly chosen SNPs is generated) or ii) "thinning", sub-samples are generated by taking SNPs one every nsub=floor(nsnp/subsamplesize) in the order of the map (a suffix ".subn" is added to each sub-sample files where n varies from 1 to nsub).}
}
\value{
Files containing allele count (in SelEstim Pool-Seq format) and SNP details (as in the snp.info matrix from the pooldata object)
}
\description{
Convert a pooldata object into SelEstim allele read count. A file containing SNP details is also printed out. Options to generate sub-samples  (e.g., for large number of SNPs) are also available.
}
\examples{
 make.example.files(writing.dir=tempdir())
 pooldata=popsync2pooldata(sync.file=paste0(tempdir(),"/ex.sync.gz"),poolsizes=rep(50,15))
 pooldata2genoselestim(pooldata=pooldata,writing.dir=tempdir())
}
\seealso{
To generate pooldata object, see \code{\link{vcf2pooldata}}, \code{\link{popsync2pooldata}}
}
