% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/out.objects.R
\docType{class}
\name{fstats-class}
\alias{fstats-class}
\alias{fstats}
\title{S4 class to represent fstats results obtained with computeFstats.}
\description{
S4 class to represent fstats results obtained with computeFstats.
}
\section{Slots}{

\describe{
\item{\code{f2.values}}{A data frame with npop(npop-1)/2 rows and 1 (or 3 if blockjackknife is TRUE) columns containing estimates of the f2-statistics over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.)}

\item{\code{fst.values}}{A data frame with npop(npop-1)/2 rows and 1 (or 3 if blockjackknife is TRUE) columns containing estimates of the scaled f2.values (same as obtained with compute.pairwiseFST with method="Identity") over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.). The F2 scaling factor is equal to 1-Q2 (where Q2 is the AIS probability between the two populations)}

\item{\code{f3.values}}{A data frame with npops(npops-1)(npops-2)/2 rows and 1 (or 4 if blockjackknife is TRUE) columns containing estimates of the f3-statistics over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.) and Z-score measuring the deviation of the f3-statistics from 0 in units of s.e.}

\item{\code{f3star.values}}{A data frame with npops(npops-1)(npops-2)/2 rows and 1 (or 4 if blockjackknife is TRUE) columns containing estimates of the scaled f3-statistics over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.) and Z-score measuring the deviation of the f3-statistics from 0 in units of s.e. The F3 scaling factor is equal to 1-Q1 (where Q1 is the AIS probability within the target population, i.e., population C for F3(C;A,B))}

\item{\code{f4.values}}{A data frame with npops(npops-1)(npops-2)(npops-3)/8 rows and 1 (or 4 if blockjackknife is TRUE) columns containing estimates of the f4-statistics over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.) and Z-score measuring the deviation of the f4-statistics from 0 in units of s.e.}

\item{\code{Dstat.values}}{A data frame with npops(npops-1)(npops-2)(npops-3)/8 rows and 1 (or 4 if blockjackknife is TRUE) columns containing estimates of the D-statistics (scaled f4-statistics) over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.) and Z-score measuring the deviation of the f3-statistics from 0 in units of s.e. For a given quadruplet (A,B;C,D), the parameter D corresponds to F4(A,B;C,D) scaled by (1-Q2(A,B))*(1-Q2(C,D)) where Q2(X,Y) is the is the AIS probability between the X and Y populations.}

\item{\code{F4.bjack.samples}}{If blockjackknife=TRUE and options return.F4.blockjackknife.samples is actived in compute.fstats, a matrix with npops(npops-1)(npops-2)(npops-3)/8 rows and nblock.jackknife samples columns}

\item{\code{comparisons}}{A list containing matrices with population names associated to the different test comparisons (e.g., the "F2" elements of the list is a npop(npop-1)/2 rows x 2 columns with each row containing the name of the two populations compared)}

\item{\code{Q.matrix}}{The estimated error covariance matrix for all the F2 and F3 estimates (required by graph fitting functions to compute graph scores)}

\item{\code{heterozygosities}}{A data frame with npop rows and 1 (or 3 if blockjackknife is TRUE) columns containing estimates of the within population heterozygosities (1-Q1) over all the SNPs and if blockjackknife=TRUE, the estimated block-jackknife and standard error (s.e.)}

\item{\code{blockjacknife}}{A logical indicating whether block-jackknife estimates of standard errors are available (TRUE) or not (FALSE)}
}}

\seealso{
To generate pairwise object, see \code{\link{compute.pairwiseFST}}
}
