% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rooted.njtree.builder.R
\name{rooted.njtree.builder}
\alias{rooted.njtree.builder}
\title{Construct and root an Neighbor-Joining tree of presumably nonadmixed leaves}
\usage{
rooted.njtree.builder(
  fstats,
  pop.sel,
  edge.fact = 1000,
  plot.nj = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{fstats}{Object of class fstats that contains estimates of the fstats (see compute.fstats)}

\item{pop.sel}{Names of the leaves (pops) used to build the nj tree (at least 3 required)}

\item{edge.fact}{The multiplying factor of edges length in graph representation}

\item{plot.nj}{If TRUE plot the Neighbor-Joining tree}

\item{verbose}{If TRUE extra information is printed on the terminal}
}
\value{
A list with the following elements:
\enumerate{
\item "n.rooted.trees": The number of possible rooted binary trees that were evaluated
\item "fitted.rooted.trees.list": a list of objects of class fitted.graph containing information on all the possible graphs (indexed from 1 to n.rooted.trees). Each tree may be visualized or further used using functions applied to objects of class fitted.graph (e.g., plot, add.leave) 
\item best.rooted.tree The tree (object of class fitted.graph) among all the graphs within fitted.rooted.trees.list displaying the minimal the minimal sd over estimates of h_P (see details) 
\item "root.het.est.var": For a matrix of n.tree rows (same order as in the list rooted.tree) and 4 columns with i) the average estimated root heterozygosity h_R across all the pairs of population leave that are relevant for estimation (see details); ii) the size of the range of variation and iii) the s.d. of the estimates of h_R, and iv) the number of population pairs relevant for estimation 
\item "nj.tree.eval": If n.edges>3, gives the five worst configuration fit (by calling the compare.fitted.fstats function) which are the same irrespective of rooting
}
}
\description{
Construct and root an Neighbor-Joining tree of presumably nonadmixed leaves
}
\details{
A Neighbor-Joining tree is first built (using nj function from the package ape) based on the F2-distance matrix of the leaves in pop.sel which are presumably non-admixed (see the function find.tree.popset to find such groups of scaffold populations using estimated F3 and F4 test statistics). For non-admixed leaves, F2 are indeed expected to be additive along the resulting binary tree (see Lipson et al., 2013). The resulting tree is then rooted using the method described in Lipson et al. (2013) which is based on the property that the estimated heterozygosity of the root h_R equals h_R=1-Q2(A,B) if A and B are two populations sharing R as the only common ancestor in the tree. This estimator should then be consistent across all the possible pairs of populations A and B that are only connected through R in the tree (i.e., that each belong to one of the two partitions of the tree defined by a root position R). Note that 1-Q2(A,B)=(1-Q1(A))/2 + (1-Q1(B))/2 + F2(A,B)=(h_A+h_B)/2+F2(A,B) where h_A, h_B and F2(A,B) are estimated with the function compute.fstats.
}
\seealso{
see \code{\link{fit.graph}}, \code{\link{generate.graph.params}} and \code{\link{add.leaf}}.
}
