% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma_constantscale.R
\name{gamma_constantscale}
\alias{gamma_constantscale}
\title{Fit Constant-Scale Gamma Model for Y vs. Covariates}
\usage{
gamma_constantscale(y, x = NULL, var = TRUE)
}
\arguments{
\item{y}{Numeric vector.}

\item{x}{Numeric vector or matrix. If \code{NULL}, model reduces to marginal
Gamma model Y ~ Gamma(exp(beta_0), b).}

\item{var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}
}
\value{
List of parameter estimates, variance-covariance matrix (if
requested), AIC, and \code{\link[stats]{nlminb}} object.
}
\description{
Uses maximum likelihood to fit
Y|\strong{X} ~ Gamma(exp(beta_0 + \strong{beta_x}^T \strong{X}), b), with the
shape-scale (as opposed to shape-rate) parameterization described in
\code{\link[stats]{GammaDist}}.
}
\examples{
# Generate data
set.seed(123)
x <- rnorm(1000)
y <- rgamma(1000, shape = exp(0.5 + 0.25 * x), scale = 0.25)

# Fit model
fit <- gamma_constantscale(y = y, x = x)
fit$theta.hat
fit$varcov
fit$aic

# Plot E(Y) vs. X according to model fit
plot(x, y, main = "Gamma Model for Y vs. X")
xvals <- seq(min(x), max(x), 0.01)
yvals <- exp(fit$theta.hat[1] + fit$theta.hat[2] * xvals) * fit$theta.hat[3]
points(xvals, yvals, type = "l")


}
