% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dfa.R
\name{plot_dfa}
\alias{plot_dfa}
\title{Plot Log-OR vs. X for Normal Discriminant Function Approach}
\usage{
plot_dfa(estimates, varcov = NULL, xrange, xname = "X", cvals = NULL,
  set_labels = NULL, set_panels = TRUE)
}
\arguments{
\item{estimates}{Numeric vector of point estimates for
\code{(gamma_0, gamma_y, gamma_c^T, sigsq)}.}

\item{varcov}{Numeric matrix with variance-covariance matrix for
\code{estimates}. If \code{NULL}, 95\% confidence bands are omitted.}

\item{xrange}{Numeric vector specifying range of X values to plot.}

\item{xname}{Character vector specifying name of X variable, for
plot title and x-axis label.}

\item{cvals}{Numeric vector or list of numeric vectors specifying covariate
values to use in log-odds ratio calculations.}

\item{set_labels}{Character vector of labels for the sets of covariate
values. Only used if \code{cvals} is a list.}

\item{set_panels}{Logical value for whether to use separate panels for each
set of covariate values, as opposed to using different colors on a single
plot.}
}
\value{
Plot of log-OR vs. \code{X} generated by
\code{\link[ggplot2]{ggplot}}.
}
\description{
Archived on 7/23/2018. Please use \code{\link{plot_ndfa}} instead.
}
\examples{
# Fit discriminant function model for poolwise Xtilde vs. (Y, C), without
# assuming a constant log-OR. Ignoring processing errors for simplicity.
data(pdat1)
fit <- p_dfa_xerrors(g = pdat1$g, y = pdat1$numcases, xtilde = pdat1$xtilde,
                     c = pdat1$c, errors = "neither", constant_or = FALSE)

# Plot estimated log-OR vs. X at mean value for C
p <- plot_dfa(estimates = fit$estimates, varcov = fit$theta.var,
              xrange = range(pdat1$xtilde / pdat1$g),
              cvals = mean(pdat1$c / pdat1$g))
p


}
