% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ndfa.R
\name{plot_ndfa}
\alias{plot_ndfa}
\title{Plot Log-OR vs. X for Normal Discriminant Function Approach}
\usage{
plot_ndfa(estimates, varcov = NULL, xrange, xname = "X",
  cvals = NULL, set_labels = NULL, set_panels = TRUE)
}
\arguments{
\item{estimates}{Numeric vector of point estimates for
\code{(gamma_0, gamma_y, gamma_c^T, sigsq)}.}

\item{varcov}{Numeric matrix with variance-covariance matrix for
\code{estimates}. If \code{NULL}, 95\% confidence bands are omitted.}

\item{xrange}{Numeric vector specifying range of X values to plot.}

\item{xname}{Character vector specifying name of X variable, for
plot title and x-axis label.}

\item{cvals}{Numeric vector or list of numeric vectors specifying covariate
values to use in log-odds ratio calculations.}

\item{set_labels}{Character vector of labels for the sets of covariate
values. Only used if \code{cvals} is a list.}

\item{set_panels}{Logical value for whether to use separate panels for each
set of covariate values, as opposed to using different colors on a single
plot.}
}
\value{
Plot of log-OR vs. X generated by \code{\link[ggplot2]{ggplot}}.
}
\description{
When \code{\link{p_ndfa}} is fit with \code{constant_or = FALSE}, the
log-OR for X depends on the value of X (and covariates, if any). This
function plots the log-OR vs. X for one or several sets of covariate values.
}
\examples{
# Fit discriminant function model for poolwise X vs. (Y, C), without assuming
# a constant log-OR. Note that data were generated with a constant log-OR of
# 0.5.
data(dat_p_ndfa)
dat <- dat_p_ndfa$dat
fit <- p_ndfa(
  g = dat$g,
  y = dat$numcases,
  xtilde = dat$x,
  c = dat$c,
  errors = "neither",
  constant_or = FALSE
)

# Plot estimated log-OR vs. X, holding C fixed at the sample mean.
p <- plot_ndfa(
  estimates = fit$estimates,
  varcov = fit$theta.var,
  xrange = range(dat$x[dat$g == 1]),
  cvals = mean(dat$c / dat$g)
)
p


}
