% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_by.R
\name{nest_by}
\alias{nest_by}
\title{Nest By}
\usage{
nest_by(.data, ..., .key = "data", .keep = FALSE)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Grouping specification, forwarded to \code{\link[=group_by]{group_by()}}.}

\item{.key}{\code{character(1)}. The name of the column in which to nest the data (default: "data").}

\item{.keep}{\code{logical(1)}. Should the grouping columns be kept (default: TRUE)?}
}
\description{
\code{nest_by()} is similar to \code{\link[=group_by]{group_by()}} however instead of storing the group structure in the metadata, it is made
explicit in the data. Each group key is given a single row within the \code{data.frame} and the group's data is stored
within a list-column of the \code{data.frame}.
}
\details{
Currently there is no pretty-printing provided for the results of \code{nest_by()} and they are not useble with other
functions such as \code{\link[=mutate]{mutate()}}.
}
\examples{
mtcars \%>\% nest_by(am, cyl)
# Or equivalently
mtcars \%>\% group_by(am, cyl) \%>\% nest_by()

}
