% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst.R
\name{fst}
\alias{fst}
\title{Calculate FST from a population-level kinship matrix or vector of inbreeding coefficients}
\usage{
fst(x, weights = NULL)
}
\arguments{
\item{x}{The vector of inbreeding coefficients, or the kinship matrix if \code{x} is a matrix.}

\item{weights}{Weights for individuals (optional, defaults to uniform weights)}
}
\value{
\eqn{F_{ST}}{FST}
}
\description{
This function simply returns the weighted mean inbreeding coefficient.
If weights are \code{NULL} (default), the regular mean is calculated.
If a kinship matrix is provided, then the inbreeding coefficients are extracted from its diagonal using \code{\link{inbr}} (requires the diagonal to contains self-kinship values (\eqn{\phi_{jj}^T = \frac{1}{2}(1+f_j^T)}{\phi_jj^T = (1+f_j^T)/2}) as \code{\link{popkin}} returns, and not inbreeding coefficients (\eqn{f_j^T}) as \code{\link{inbr_diag}} returns).
}
\details{
The returned weighted mean inbreeding coefficient equals the generalized \eqn{F_{ST}}{FST} if all individuals are "locally outbred" (i.e. if the self-relatedness of every individual stems entirely from the population structure rather than due partly to having unusually closely related parents, such as first or second cousins).
Note most individuals in population-scale human data are locally outbred.
If there are locally-inbred individuals, the returned value will overestimate \eqn{F_{ST}}{FST}.
}
\examples{
# Get FST from a genotype matrix

# Construct toy data
X <- matrix(c(0,1,2,1,0,1,1,0,2), nrow = 3, byrow = TRUE) # genotype matrix
subpops <- c(1,1,2) # subpopulation assignments for individuals

# NOTE: for BED-formatted input, use BEDMatrix!
# "file" is path to BED file (excluding .bed extension)
## library(BEDMatrix)
## X <- BEDMatrix(file) # load genotype matrix object

# estimate the kinship matrix "kinship" from the genotypes "X"!
kinship <- popkin(X, subpops) # calculate kinship from X and optional subpop labels
weights <- weights_subpops(subpops) # can weigh individuals so subpopulations are balanced
Fst <- fst(kinship, weights) # use kinship matrix and weights to calculate fst

Fst <- fst(kinship) # no (or NULL) weights implies uniform weights

inbr <- inbr(kinship) # if you extracted inbr for some other analysis...
Fst <- fst(inbr, weights) # ...use this inbreeding vector as input too!

}
