% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_rodent_data.R
\name{clean_rodent_data}
\alias{clean_rodent_data}
\title{Do basic cleaning of Portal rodent data}
\usage{
clean_rodent_data(
  rodent_data,
  species_table,
  fillweight = FALSE,
  type = "Rodents",
  unknowns = FALSE
)
}
\arguments{
\item{rodent_data}{the raw rodent data table}

\item{species_table}{the species table}

\item{fillweight}{specify whether to fill in unknown weights with other
records from that individual or species, where possible}

\item{type}{specify subset of species; either all "Rodents" or only
"Granivores"}

\item{unknowns}{either removes all individuals not identified to species
(unknowns = FALSE) or sums them in an additional column (unknowns = TRUE)}
}
\description{
This function does basic quality control of the Portal rodent
  data. It is mainly called from \code{\link{summarize_rodent_data}}, with
  several arguments passed along.

  The specific steps it does are, in order:
    (1) add in missing weight data
    (2) remove records with "bad" period codes or plot numbers
    (3) remove records for unidentified species
    (4) exclude non-granivores
    (5) exclude incomplete trapping sessions
    (6) exclude the plots that aren't long-term treatments
}
