% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_measures.R
\name{est_es}
\alias{est_es}
\title{Estimate the Expected Shortfall (ES)}
\usage{
est_es(sample, alpha, method = c("mean", "median", "mc"), mc_samples = 100)
}
\arguments{
\item{sample}{Numeric vector representing the sample upon which the Expected
Shortfall is calculated.}

\item{alpha}{Numeric vector with entries in (0,1) specifying the levels at
which the ES is calculated.}

\item{method}{Method of estimation one of \code{mean}, \code{median}, \code{mc}. For more
information see the Description section.}

\item{mc_samples}{Number of Monte Carlo samples used for the \code{mc} method.}
}
\value{
Numeric vector with Expected Shortfall estimates
(same length as \code{alpha}).
}
\description{
The Expected Shortfall at level \eqn{\alpha} is defined as the expected value
of the returns under the condition that the returns are smaller than the
Value at Risk for the same \eqn{\alpha} level. Note that an absolutely
continuous distribution of the returns is assumed.
The three estimation methods are:
\itemize{
\item \code{mean} the mean of the samples that fall under the corresponding VaR.
\item \code{median} the median of the samples that fall under the corresponding VaR.
\item \code{mc} Calculation of the expected value using Monte Carlo integration over
the \eqn{\alpha} levels. One draws \code{mc_samples} Monte Carlo samples .
}
}
\examples{
est_es(0:100, c(0.1, 0.2, 0.3))
}
\seealso{
\code{\link[=est_var]{est_var()}}
}
