########################################################################################################################################
########################################################################################################################################
# BubleyDyerMRPGenerator
########################################################################################################################################
########################################################################################################################################

#' @title
#' Generator of an approximated MRP matrix.
#'
#' @description
#' Creates an object of S4 class `BubleyDyerMRPGenerator` for the computation of an approximated
#' MRP matrix, starting from a set of random linear extensions, sampled according to the Bubley-Dyer procedure.
#' Actually, this function does not compute the MRP matrix, but just the object that will compute it,
#' by using function `BubleyDyerMRP`.
#'
#' @param poset Object of S4 class `POSet` representing the poset whose MRP are computed.
#' Argument `poset` must be created by using any function contained in the package aimed at building object of S4 class `POSet`
#' (e.g. [POSet()], [LinearPOSet()], [ProductPOSet()], ...) .
#'
#' @param seed Positive integer to initialize the random linear extension generation.
#'
#' @return
#' An object of S4 class `BubleyDyerMRPGenerator`.
#'
#' @examples
##################
#' el <- c("a", "b", "c", "d")
#'
#' dom <- matrix(c(
#'   "a", "b",
#'   "c", "b",
#'   "b", "d"
#' ), ncol = 2, byrow = TRUE)
#'
#' pos <- POSet(elements = el, dom = dom)
#'
#' BDgen <- BubleyDyerMRPGenerator(pos)
#'
#' @name BubleyDyerMRPGenerator
#' @export BubleyDyerMRPGenerator
BubleyDyerMRPGenerator <- function(poset=NULL, seed=NULL) {
  if (!methods::is(poset, "POSet")) {
    stop("poset must be of class POSet")
  }
  if (!is.null(seed) && (seed < 0 || seed != round(seed))) {
    stop("seed must be a positive integer")
  }
  tryCatch({
    ptr <- .Call("_BuildBubleyDyerMRPGenerator", poset@ptr, seed)
    result <- methods::new("BubleyDyerMRPGenerator", ptr=ptr)
    return (result)
    return (0)
  }, error = function(err) {
    err_split <- strsplit(err[[1]], split = ":")
    stop(err_split[[1]][length(err_split[[1]])])
  }) # END tryCatch
}
