% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExactEvaluation.R
\name{ExactEvaluation}
\alias{ExactEvaluation}
\title{Computing function mean values on linear extensions}
\usage{
ExactEvaluation(poset, output_every_sec = NULL, f1, ...)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet} representing the poset from which linear extensions are generated.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{output_every_sec}{integer specifying a time interval (in seconds).
By specifying this argument, during the execution of \code{BubleyDyerEvaluation}, the number of linear extensions
progressively generated is printed on the R-Console, every \code{output_every_sec}seconds.}

\item{f1}{the function whose average value has to be computed.
\code{f1} can be an R-function having as a single argument a linear extension of \code{poset} and returning a numerical matrix.}

\item{...}{Further functions whose averages are to be computed.}
}
\value{
A list of the computed averages, along with the number of linear extensions generated to compute them.
}
\description{
\code{ExactEvaluation} computes the mean values of the input functions (defined on linear orders) over
the set of linear extensions of the input poset.
The linear extensions are generated according to the algorithm given in Habib M, Medina R, Nourine L and Steiner G (2001).
}
\examples{
el1 <- c("a", "b", "c", "d")
el2 <- c("x", "y")
el3 <- c("h", "k")
dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos1 <- POSet(elements = el1, dom = dom)

pos2 <- LinearPOSet(elements = el2)

pos3 <- LinearPOSet(elements = el3)

pos <- ProductPOSet(pos1, pos2, pos3)

# median_distr computes the frequency distribution of median profile

elements <- POSetElements(pos)

median_distr <- function(le) {
  n <- length(elements)
  if (n \%\% 2 != 0) {
    res <- (elements == le[(n + 1) / 2])
  } else {
    res <- (elements == le[n / 2])
  }
  res <- as.matrix(res)
  rownames(res) <- elements
  colnames(res) <- "median_distr"
  return (as.matrix(res))
}
\donttest{
res  <- ExactEvaluation(pos, output_every_sec=1, median_distr)
}

}
\references{
Habib M, Medina R, Nourine L and Steiner G (2001). Efficient algorithms on distributive lattices.
Discrete Applied Mathematics, 110, 169-187. https://doi.org/10.1016/S0166-218X(00)00258-4.
}
