% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/POSetJoin.R
\name{POSetJoin}
\alias{POSetJoin}
\title{Computing join (least upper bound).}
\usage{
POSetJoin(poset, elements)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset} must be created by using any function contained in the package
aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{elements}{A list of character strings (the names of some poset elements).}
}
\value{
A character string (the name of the join).
}
\description{
The function computes the join (if existing) of a set of elements, in the input poset.
}
\examples{
elems <- c("a", "b", "c", "d")

doms <- matrix(c(
  "a", "b",
  "c", "b",
  "a", "d",
  "a", "a",
  "b", "b",
  "c", "c",
  "d", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = doms)

lub<-POSetJoin(pos, c("a", "c"))


}
