% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols_dispatch.R
\name{ols_helper}
\alias{ols_helper}
\title{Helper function(least squares).}
\usage{
ols_helper(X, Y, W)
}
\arguments{
\item{X}{A matrix of covariates (must be all numeric)}

\item{Y}{A vector of the target variable, of same length as the number of rows of Y, must be numeric}

\item{W}{A vector of the treatment variable, of same length as the number of rows of X, must be numeric}
}
\value{
A list with two elements: The fitted W model and the fitted Y model.
}
\description{
Helper function that dispatches to OLS for the post-double estimation.
}
\details{
This function is mostly implemented to provide the option to use ols with cross fitting, though it is assumed that this will be rarely used.
}
\examples{

  n = 2000; p = 10
  X = matrix(rnorm(n*p), n, p)
  W = rbinom(n, 1, 0.4 + 0.2 * (X[,1] > 0))
  Y = pmax(X[,1], 0) * W + X[,2] + pmin(X[,3], 0) + rnorm(n)

ols_helper(X = X,Y = Y, W = W)


}
