% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rockjock}
\alias{rockjock}
\title{RockJock reference library}
\format{A list of 3 components
\describe{
\item{xrd}{A dataframe of all xrd data (counts only). Column names denote the
reference sample}
\item{tth}{A vector of 2theta intervals of all measurements in the library}
\item{phases}{A dataframe the phase ID's, names and reference intensity
ratios (RIR)}
}}
\usage{
rockjock
}
\description{
A \code{powdRlib} object of 168 pure reference patterns from the RockJock
library (Cu K-alpha radiation) along with reference intensity ratios.Can be
used with the \code{fps()} and \code{afps()} functions for quantitative
analysis. Example mixtures for testing the \code{rockjock} library with known
concentrations are available in the \code{rockjock_mixtures} data. See
\code{?rockjock_mixtures}.
}
\references{
Eberl, D.D., 2003. User's guide to RockJock - A program for determining quantitative mineralogy from
powder X-ray diffraction data. Boulder, CA.
}
\author{
Dennis Eberl
}
\keyword{datasets}
