% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine-sequential.R
\name{brms_inla_power_sequential}
\alias{brms_inla_power_sequential}
\title{Sequential Bayesian Assurance Simulation Engine (Modern, Multi-Effect Ready)}
\usage{
brms_inla_power_sequential(
  formula,
  family = gaussian(),
  family_control = NULL,
  Ntrials = NULL,
  E = NULL,
  scale = NULL,
  priors = NULL,
  data_generator = NULL,
  effect_name,
  effect_grid,
  sample_sizes,
  metric = c("direction", "threshold", "rope", "bf"),
  target = 0.8,
  prob_threshold = 0.95,
  effect_threshold = 0,
  rope_bounds = NULL,
  credible_level = 0.95,
  compute_bayes_factor = FALSE,
  error_sd = 1,
  group_sd = 0.5,
  obs_per_group = 10,
  predictor_means = NULL,
  predictor_sds = NULL,
  seed = 1,
  batch_size = 20,
  min_sims = 40,
  max_sims = 600,
  ci_conf = 0.95,
  margin = 0.02,
  inla_num_threads = NULL,
  family_args = list(),
  progress = TRUE
)
}
\arguments{
\item{formula}{brms-style model formula.}

\item{family}{GLM family (e.g., gaussian(), binomial()).}

\item{family_control}{Optional list for INLA's control.family.}

\item{Ntrials}{Optional vector of binomial trial counts (for binomial families).}

\item{E}{Optional vector of exposures (for Poisson families).}

\item{scale}{Optional numeric vector for scale parameter in INLA.}

\item{priors}{brms prior specification object.}

\item{data_generator}{Optional function(n, effect) to simulate data.}

\item{effect_name}{Character vector of fixed effects to assess.}

\item{effect_grid}{Data frame or vector of effect values.}

\item{sample_sizes}{Vector of sample sizes.}

\item{metric}{Character; one of "direction", "threshold", "rope", or "bf" for Bayesian decision metric.}

\item{target}{Target assurance value for stopping.}

\item{prob_threshold}{Posterior probability threshold for decision metrics.}

\item{effect_threshold}{Effect-size threshold.}

\item{rope_bounds}{Numeric length-2 vector defining ROPE.}

\item{credible_level}{Credible interval level for Bayesian inference.}

\item{compute_bayes_factor}{Logical; TRUE if metric is "bf".}

\item{error_sd}{Residual standard deviation.}

\item{group_sd}{Standard deviation of random effects.}

\item{obs_per_group}{Number of observations per group.}

\item{predictor_means}{Optional named list of predictor means.}

\item{predictor_sds}{Optional named list of predictor standard deviations.}

\item{seed}{Random seed.}

\item{batch_size}{Number of simulations per sequential look.}

\item{min_sims}{Minimum simulations before early stopping.}

\item{max_sims}{Maximum simulations per cell.}

\item{ci_conf}{Confidence level for Wilson confidence intervals.}

\item{margin}{Margin around target for early stopping decision.}

\item{inla_num_threads}{Character string specifying INLA threading (e.g., "4:1").
If NULL (default), automatically detects optimal setting based on CPU cores.}

\item{family_args}{List of family-specific args passed to data generator.}

\item{progress}{Logical; if TRUE, show progress messages.}
}
\value{
List containing summary per cell and simulation settings.
}
\description{
Simulates assurance sequentially in batches, stopping early per cell based on Wilson confidence intervals.
}
\details{
Sequential Bayesian Assurance Simulation Engine (Modern, Multi-Effect Ready)

Simulates assurance sequentially in batches, stopping early per cell based on Wilson confidence intervals.
}
\examples{
\donttest{
# Sequential design with automatic threading
results <- brms_inla_power_sequential(
  formula = outcome ~ treatment,
  effect_name = "treatment",
  effect_grid = c(0.2, 0.5, 0.8),
  sample_sizes = c(50, 100, 200),
  metric = "direction",
  target = 0.80
)
print(results$summary)
}
}
