% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_data.R
\name{dropout_weibull}
\alias{dropout_weibull}
\title{Use the Weibull distribution to specify the dropout process}
\usage{
dropout_weibull(proportion, rate)
}
\arguments{
\item{proportion}{Total proportion of subjects that have dropped out
at the last time point. Must be less than 1.}

\item{rate}{Indicates the "shape" of the dropout process, if > 1 then dropout is
concentrated at the end of the study, if \code{rate} < 1 more dropout occurs at
the beginning of the study. If \code{rate} == 1 the risk of dropout is constant.}
}
\value{
A \code{plcp_weibull} named \code{list}, with the first element containing the
dropout \code{function}.
}
\description{
Used as input to the \code{dropout}-argument in \code{\link{study_parameters}}
}
\details{
N.B a constant (rate = 1) hazard of dropout does not mean dropout
is linear over time. It means that the risk of dropping out at the next
time point is constant over the study period.
}
\examples{
p <- study_parameters(n1 = 11,
                      n2 = 5,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      dropout = dropout_weibull(proportion = 0.3, rate = 3),
                      cohend = -0.8)

get_dropout(p)
plot(p, plot = 2)

# Different per treatment
tx <- dropout_weibull(proportion = 0.3, rate = 3)
cc <- dropout_weibull(proportion = 0.3, rate = 1/3)
dropout <- per_treatment(control = cc,
                         treatment = tx)

p <- study_parameters(n1 = 11,
                      n2 = 5,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      dropout = dropout,
                      cohend = -0.8)

plot(p, plot = 2)

# Compare power for different dropout amounts
dropout <- c(dropout_weibull(proportion = 0.3, rate = 3),
             dropout_weibull(proportion = 0.5, rate = 3),
             dropout_weibull(proportion = 0.5, rate = 1/3))

p <- study_parameters(n1 = 11,
                      n2 = 5,
                      n3 = 6,
                      T_end = 10,
                      icc_pre_subject = 0.5,
                      icc_pre_cluster = 0,
                      var_ratio = 0.03,
                      icc_slope = 0.05,
                      dropout = dropout,
                      cohend = -0.8)

get_power(p)
}
\references{
Galbraith, S., Stat, M., & Marschner, I. C. (2002).
Guidelines for the design of clinical trials with longitudinal outcomes.
\emph{Controlled clinical trials, 23}(3), 257-273.
}
\seealso{
\code{\link{dropout_manual}}, \code{\link{per_treatment}}
}
