% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_data.R
\docType{data}
\name{ppiDOM2010}
\alias{ppiDOM2010}
\title{Poverty Probability Index (PPI) lookup table for Dominican Republic}
\format{
A data frame with 11 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl50}}{National poverty line (50\%)}
\item{\code{nl75}}{National poverty line (75\%)}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $3.75 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiDOM2010
}
\description{
Poverty Probability Index (PPI) lookup table for Dominican Republic
}
\examples{
  # Access Dominican Republic PPI table
  ppiDOM2010

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiDOM2010[ppiDOM2010$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiDOM2010, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiDOM2010[ppiDOM2010$score == ppiScore, "extreme"]

}
\keyword{datasets}
