% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{find_ql}
\alias{find_ql}
\title{Convert index into group pair}
\usage{
find_ql(ind_ql, Q, directed = TRUE)
}
\arguments{
\item{ind_ql}{Converted \eqn{(q,l)} index}

\item{Q}{Total number of groups \eqn{Q}}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}
}
\value{
Group pair \eqn{(q,l)} corresponding to the given index
}
\description{
This function is the inverse of the conversion \eqn{{(q,l), q,l} } into \eqn{{1,...,Q^2}} for the directed case \eqn{{(q,l), q<= l}} into \eqn{{1,...,Q*(Q+1)/2}} for the undirected case.
It takes the integer index corresponding to \eqn{(q,l)} and returns \eqn{(q,l)}.
}
\examples{
# Convert the index 5 into a group pair for undirected graph
# and the index 8 into a group pair for directed graph
# where the total number of group is 3

ind_ql_dir <- 8
ind_ql_undir <- 5

Q <- 3

directedIndex <- find_ql(ind_ql_dir,Q)
undirectedIndex <- find_ql(ind_ql_undir,Q, FALSE)

}
