% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/array.to.xxyy.R
\name{array.to.xxyy}
\alias{array.to.xxyy}
\title{Convert (p x k x n) data array into 2D data matrix}
\usage{
array.to.xxyy(A)
}
\arguments{
\item{A}{A 3D array (p x k x n) containing landmark coordinates for a set of specimens}
}
\value{
Function returns a two-dimensional matrix of dimension (n x [p x k]),
where rows represent specimens and columns represent variables.
The p first columns correspond to X coordinates, etc.
}
\description{
Convert a three-dimensional array of landmark coordinates into a two-dimensional matrix
}
\examples{
A <- array(rnorm(40), c(5, 2, 4))  # random 2D coordinates of 5 landmarks for 4 specimens
array.to.xxyy(A)

}
\seealso{
\code{\link{xxyy.to.array}}
}
