% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specplot.R
\name{specplot}
\alias{specplot}
\title{Plot spectrogram}
\usage{
specplot(
  sig,
  sr,
  t,
  start,
  end,
  tfrom0 = TRUE,
  freqRange = c(0, 5000),
  windowLength = 0.005,
  dynamicRange = 60,
  timeStep = 1000,
  windowShape = "Gaussian",
  colors = c("white", "black"),
  pitch_plotOnSpec = FALSE,
  pt = NULL,
  pitch_plotType = "draw",
  pitch_scale = "hz",
  pitch_freqRange = NULL,
  pitch_axisLabel = NULL,
  pitch_color = "black",
  formant_plotOnSpec = FALSE,
  fm = NULL,
  formant_plotType = "speckle",
  formant_dynamicRange = 30,
  formant_color = "black",
  intensity_plotOnSpec = FALSE,
  it = NULL,
  intensity_range = NULL,
  intensity_axisLabel = "Intensity (dB)",
  intensity_color = "black",
  tgbool = FALSE,
  lines = NULL,
  focusTierColor = "black",
  focusTierLineType = "dotted",
  ind = NULL,
  min_max_only = TRUE,
  axisLabel = "Frequency (Hz)",
  drawSize = 1,
  speckleSize = 1
)
}
\arguments{
\item{sig}{Numeric vector corresponding to a sound signal.}

\item{sr}{Integer giving the sampling rate of the signal.}

\item{t}{Numeric vector giving times corresponding to the signal.}

\item{start}{Start time (in seconds) of desired plotted area.}

\item{end}{End time (in seconds) of desired plotted area.}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{freqRange}{Vector of two integers giving the frequency range to be
used for plotting spectrograms. Default is \code{c(0,5000)}.}

\item{windowLength}{Window length in seconds for generating spectrograms.
Default is \code{0.005}.}

\item{dynamicRange}{Dynamic range in dB for generating spectrograms. The
maximum intensity minus \code{dynamicRange} will all be printed in white. Default
is \code{50}.}

\item{timeStep}{How many time steps should be calculated for spectrograms?
Default is \code{1000}. Note that this takes a while to plot, so for fiddling with
plotting parameters it is a good idea to choose a smaller value.}

\item{windowShape}{String giving the name of the window shape to be applied
to the signal when generating spectrograms. Default is \code{Gaussian}; other
options are \code{square}, \code{Hamming}, \code{Bartlett}, \code{Hanning}, or \code{Blackman}.
Note that the Gaussian window function provided by the \code{phonTools} package
and used in \code{praatpicture()} does not have the same properties as the
Gaussian window function used for spectral estimation in Praat; plotting
a simple sine wave with high dynamic range will produce sidelobes in
\code{praatpicture()} but not in Praat. It's recommended to use Blackman windows
instead if you have this problem.}

\item{colors}{Vector of strings giving the names of colors to be used
for plotting the spectrogram; default is \code{c('white', 'black')}. The first
value is used for plotting the lowest visible amplitude, and the last for
plotting the highest visible amplitude. Vectors with more than two color
names can be used for plotting values in between in different colors.}

\item{pitch_plotOnSpec}{Boolean; should pitch be plotted on top of
spectrogram? Default is \code{FALSE}.}

\item{pt}{Pitch object loaded using \link[rPraat:pt.read]{rPraat::pt.read} or similar object.}

\item{pitch_plotType}{String giving the type of pitch plot to produce; default
is \code{draw} (a line plot), the only other option is \code{speckle} (a point plot).
Alternatively a vector \code{c('draw','speckle')} can be passed, in which case
both are used.}

\item{pitch_scale}{String giving the frequency scale to use when producing
pitch plots. Default is \code{hz}; other options are \code{logarithmic} (also in Hz),
\code{semitones}, \code{erb}, and \code{mel}.}

\item{pitch_freqRange}{Vector of two integers giving the frequency range to be
used for producing pitch plots. Default is \code{NULL}, in which case the pitch
range is automatically reset to \code{c(-12,30)} for the \code{semitones} scale,
\code{c(0,10)} for the \code{erb} scale, and \code{c(50,500)} for the Hz-based scales,
following Praat defaults.}

\item{pitch_axisLabel}{String giving the name of the label to print along the
y-axis when printing a pitch track. Default is \code{NULL}, in which case the
axis label will depend on the scale.}

\item{pitch_color}{String or vector of strings giving the name of the color
to be used for plotting pitch. Default is \code{'black'}. If a vector of two
strings is passed, the second color will be used for background highlighting.}

\item{formant_plotOnSpec}{Boolean; should formants be plotted on top of
spectrogram? Default is \code{FALSE}.}

\item{fm}{Formant object loaded using \link[rPraat:formant.read]{rPraat::formant.read} or similar
object.}

\item{formant_plotType}{String giving the type of formant plot to produce;
default is \code{speckle} (a point plot), the only other option is \code{draw} (a line
plot). Alternatively a vector \code{c('draw','speckle')} can be passed, in which
case both are used.}

\item{formant_dynamicRange}{Dynamic range in dB for producing formant plots.
When a formant plot of \code{formant_plotType='speckle'} is drawn, no formants are
shown in frames with intensity level \code{formant_dynamicRange} below the maximum
intensity. Default is \code{30}. If set to \code{0}, all formants are shown.}

\item{formant_color}{String or vector of strings giving the name(s) of
colors to be used for plotting formants. If one color is provided, all
formants will be plotted in this color. If multiple colors are provided,
different formants will be shown in different colors. Default is \code{'black'}.
If the length of this vector twice the number of formants plotted, the first
half of strings will be used for the formants' primary colors and the second
half will be used for background highlighting. If the length of this vector
is one more than the number of formants plotted, the last string will
be used for background highlighting.}

\item{intensity_plotOnSpec}{Boolean; should intensity be plotted on top of
spectrogram? Default is \code{FALSE}.}

\item{it}{Intensity object loaded using \link[rPraat:it.read]{rPraat::it.read} or similar object.}

\item{intensity_range}{Vector of two integers giving the intensity range to be
used for producing intensity plots. Default is \code{NULL}, in which case the
range is simply the minimum and maximum levels in the curve.}

\item{intensity_axisLabel}{String giving the name of the label to print along
the y-axis when plotting intensity. Default is \code{Intensity (dB)}.}

\item{intensity_color}{String or vector of strings giving the name of the
color to be used for plotting intensity. Default is \code{'black'}. If a vector of
two strings is passed, the second color will be used for background
highlighting.}

\item{tgbool}{Logical; should dotted lines be plotted corresponding to
locations in a TextGrid? Default is \code{FALSE}.}

\item{lines}{Numeric vector giving locations in seconds of locations from
a TextGrid to be plotted with dotted lines. Default is \code{NULL}.}

\item{focusTierColor}{String or vector of strings giving the color(s) to
use for plotting focus tier lines. If multiple tiers are focused, a vector
of the same length can be passed, and the nth tier will be plotted in the
nth color. Default is \code{'black'}.}

\item{focusTierLineType}{String or vector of strings giving the line
type(s) for plotting focus tier lines. If multiple tiers are focused, a
vector of the same length can be passed, and the nth tier will be plotted in
the nth line type. Default is \code{'dotted'}.}

\item{ind}{Integer indexing waveform relative to other plot components.
Default is \code{NULL}.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{TRUE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{axisLabel}{String giving the name of the label to print along the
y-axis when plotting a spectrogram. Default is \code{Frequency (Hz)}.}

\item{drawSize}{Number indicating the line width of plot components where
the \verb{_plotType} is \code{'draw'} (i.e., pitch, formants, or intensity rendered as
line plots). Default is \code{1}. Controls the \code{lwd} argument of
\link[graphics:lines]{graphics::lines}.}

\item{speckleSize}{Number indicating the point size of plot components where
the \verb{_plotType} is \code{'speckle'} (i.e. pitch or formants rendered as point
plots). Default is \code{1}. Controls the \code{cex} arguments of \link[graphics:points]{graphics::points}.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for plotting spectrograms called by \link{praatpicture}. Instead of using
this function directly, just use
\code{praatpicture('my_sound_file', frames='spectrogram')}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames='spectrogram')
}
