% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_TextGrid.R
\name{make_TextGrid}
\alias{make_TextGrid}
\title{Interactively create a TextGrid object}
\usage{
make_TextGrid(
  sound,
  tierNames,
  start = 0,
  end = 0,
  audioInViewer = TRUE,
  show = "wave",
  channel = 1,
  sampa2ipa = FALSE
)
}
\arguments{
\item{sound}{String giving the file name of a sound file with the .wav
extension.}

\item{tierNames}{String or vector of strings giving the name(s) of tiers in
the new TextGrid object.}

\item{start}{Start time (in seconds) of desired plotted area. Default is \code{0}.}

\item{end}{End time (in seconds) of desired plotted area. Default is \code{0}
(= the entire file).}

\item{audioInViewer}{Logical; should audio be playable from the Viewer pane
in RStudio?}

\item{show}{String giving the type of plot to show. Default is \code{wave},
another option is \code{spectrogram}. Note that spectrogram plotting is relatively
slow within this function.}

\item{channel}{Number indicating which audio channel to show. Default is \code{1}.}

\item{sampa2ipa}{Logical; should SAMPA transcriptions be converted to IPA?
Default is \code{FALSE}.}
}
\value{
A list object identical to those created by \code{\link[rPraat:tg.read]{rPraat::tg.read()}} when
loading TextGrid objects into R. This object can be passed to the \code{tg_obj}
argument when using \code{praatpicture}.
}
\description{
Annotate a sound file by interacting with waveform or spectrogram plots,
resulting in a TextGrid object which can be used for creating various
acoustic plots with time-aligned annotations with \code{\link[=praatpicture]{praatpicture()}}.
}
\details{
Running this function will show either a waveform or a spectrogram
in a separate \code{X11} graphics device window. Click on this figure in the
locations where you want to add boundaries to your TextGrid objects. This
should be done sequentially, starting with the first boundary along the
time axis and ending with the last. It does not matter where on the y-axis
you click.

Once you have indicated all the desired boundaries, you will be prompted
in the R console to say whether the tier is an interval tier or a point tier
by typing \code{y} (for interval tier) or \code{n} (for point tier). Subsequently
you will be prompted in the console to write labels corresponding to each
interval or point.

If you are creating a TextGrid with multiple tiers (i.e., if \code{tierNames}
is longer than 1), this process will be repeated for all tiers.
}
\examples{
\dontrun{
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/2.wav')
tg <- make_TextGrid(soundFile, tierNames=c('Mary', 'John', 'Bell'))
# Follow the steps shown in the console

praatpicture(soundFile, tg_obj=tg)
}
}
\seealso{
\code{make_TextGrid()} is largely a wrapper around the function
\code{\link[=tg_createTier]{tg_createTier()}} which does most of the work.
}
