% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spi.r
\name{spi}
\alias{precintcon.spi.analysis}
\alias{spi}
\title{Standardized Precipitation Index}
\usage{
spi(object, period = 3, distribution = "Gamma")
}
\arguments{
\item{object}{a daily or monthly precipitation serie.}

\item{period}{the number of months to be aggregated in the calculation
of the standardized precipitation index. (Default value: 3)}

\item{distribution}{it has no effect yet. (Default value: "Gamma")}
}
\value{
A data.frame (precintcon.spi) containing the following variables:
\itemize{
\item \code{year} is the year.
\item \code{month} is the month.
\item \code{spi} is the standardized precipitation index.
}
}
\description{
Calculates the Standardized Precipitation Index (SPI)
on a daily or monthly precipitation serie.
}
\examples{
##
# Loading the monthly precipitation serie.
data(monthly)

##
# Performing the Standardized Precipitation Index
spi(monthly, period = 3)
}
\author{
Lucas Venezian Povoa \email{lucasvenez@gmail.com}
}
\seealso{
\code{\link{precintcon.plot.spi}}
\code{\link{read.data}}
}
\keyword{anomaly}
\keyword{index}
\keyword{precipitation}
\keyword{rainfall}

