# precommit 0.4.0


Apart from two new hooks, many bug fixes and a few minor features, this release
focused on improving the user experience when installing the hooks, which caused 
users the most troubles. We enabled fast hook installation without the need for build 
time or system dependencies on all platforms thanks to the Posit Package Manager 
and removal of dependencies {git2r} and {digest}. 


**Features** 

- New hook: `no-print-statement` discovers and check for rogue print 
  statements (#505).
- New hook: `pkgdown` runs `pkgdown::check_pkgdown()` to ensure the {pkgdown}
  config is valid (#393).
- add Posit CRAN mirror to ensure macOS binary installs are possible (#488).
- `codemeta-description-updated`, `roxygenize`, and `use-tidy-description` now 
  all support a `root` argument that specifies the directory in the git repo 
  that contains the R package. Defaults to `.` since for most R package git 
  repos, the git and R package root coincide (#432, #438).
- `style-files` now supports styling of R code in Quarto docs (#449).
- `style-files` now supports file names with spaces (#516).
- Use python 3.10 by default for conda envs (#477).

**Bug Fixes**

- Make sorting consistent with `spelling::update_wordlist` (#514).
- Don't depend on dev version of styler to avoid GitHub rate limit hit (#486).
- fix roxygenize cache invalidation (#464, #520).
- fix missing namespace prefixing in roxygen hook (#525).


**Documentation**

- improve spelling (#453).  
-   `use_ci()` is now documented to take `NA`, not `NULL` for argument
    `ci` (#431).
- correct typo (#465) and fix error message (#470).

**Dependencies**

- remove {digest} dependency (#471).
- remove {git2r} dependency (#497).
- Hook dependencies update (#503, #506 #508, #513, #540, #538, #527, #521, #519).

**Infrastructure**

- Refactored hook dependency update scripts and fixed bug with repos.
- Automatic hook dependency updates (#539, #532).
- use `ubuntu-latest` instead of pinned version for tests (#481).
- use new {pkgdown} hook in this repo (#460).
- `read-only` flag for testing (#529).
- Bump actions/checkout (#509, #458) and others (#533).
- ensure local and remote pre-commit execution are the same for this repo 
  (#463).

**Other**

- Adjust to latest {roxygen2} CRAN release (#536).


Changelog from dev releases is collapsed into this patch release at the time
this release is created. If you need releases by dev release, i.e. 0.3.2.x, 
checkout this file at git tag `v0.3.2.9020`.

A big thanks goes to all people who made this release reality:

[&#x0040;AliSajid](https://github.com/AliSajid), [&#x0040;averissimo](https://github.com/averissimo), [&#x0040;clarkliming](https://github.com/clarkliming), [&#x0040;danielinteractive](https://github.com/danielinteractive), [&#x0040;denn173](https://github.com/denn173), [&#x0040;dependabot[bot]](https://github.com/dependabot), [&#x0040;EzicJ](https://github.com/EzicJ), [&#x0040;fabianegli](https://github.com/fabianegli), [&#x0040;hadley](https://github.com/hadley), [&#x0040;IndrajeetPatil](https://github.com/IndrajeetPatil), [&#x0040;jashapiro](https://github.com/jashapiro), [&#x0040;joelnitta](https://github.com/joelnitta), [&#x0040;jonathanckt](https://github.com/jonathanckt), [&#x0040;jsnel](https://github.com/jsnel), [&#x0040;kcphila](https://github.com/kcphila), [&#x0040;KoderKow](https://github.com/KoderKow), [&#x0040;KyleDCox](https://github.com/KyleDCox), [&#x0040;lorenzwalthert](https://github.com/lorenzwalthert), [&#x0040;m-muecke](https://github.com/m-muecke), [&#x0040;mythichamster](https://github.com/mythichamster), [&#x0040;ns-rse](https://github.com/ns-rse), [&#x0040;pre-commit-ci[bot]](https://github.com/pre-commit-ci), [&#x0040;russHyde](https://github.com/russHyde), [&#x0040;sempwn](https://github.com/sempwn), [&#x0040;stefanoborini](https://github.com/stefanoborini), [&#x0040;thefabnab](https://github.com/thefabnab), [&#x0040;TNonet](https://github.com/TNonet), [&#x0040;TymekDev](https://github.com/TymekDev), and [&#x0040;yogat3ch](https://github.com/yogat3ch).



# precommit 0.3.2

-   `parsable-R` hook now gives more context on where and how parsing
    fails (#423).
-   fixed R CMD check issues in devel (#425).
-   move from *experimental* to *stable* (#426).

Thanks to [\@danielinteractive](https://github.com/danielinteractive),
[\@jonocarroll](https://github.com/jonocarroll) for their contributions.

# precommit 0.3.1

**User visible changes**

-   `.pre-commit-config.yaml` templates now contain hook to validate the
    [pre-commit.ci](https://pre-commit.ci) configuration (#407).
-   {git2r} is no longer needed for user side (#417).

**Bug fixes**

-   Fix bug that prevented pkg load outside directories with precommit
    files (@mpadge, #413).
-   Ensure sorting for `spell-check` hook is case-insensitive on all
    operating systems. This may re-order your whole `inst/WORDLIST`
    (#405).
-   hook `forbid-to-commit` in template `.pre-commit-config.yaml` has
    now the correct `exclude-files` regular expression to ignore `.csv`,
    `.RData`, `.Rds`, `.rds` and `.Rhistory` (#410).

**Internals**

-   `options(install.packages.compile.from.source = "never")` is used in
    the CI to avoid failing builds due to missing build-time deps
    (#412).
-   All (R)md files in that repo are now formatted in a pandoc-compliant
    way (#415).

Thanks to [\@danielinteractive](https://github.com/danielinteractive)
and [\@mpadge](https://github.com/mpadge) for their contributions.

# precommit 0.3.0

**API changes**

-   The `style-files` hook now takes `ignore-start` and `ignore-stop`
    arguments, passed to `options("styler.ignore_start")` and
    `options("styler.ignore_stop")`. By default, {styler} defaults are
    used.
-   `use_precommit()` now exposes the argument `autoupdate`, defaulting
    to `TRUE` (which was the previous behavior). This tells {precommit}
    whether or not to run `autoupdate()` as part of the former function
    invocation (#386).

**New features**

-   New hook `no-debug-statement` checks for leftover `debug()` and
    `debugonce()` statements in the committed code (#385,
    @lukasfeick-sw).
-   The template `.pre-commit-config.yaml` does now include the hook
    `file-contents-sorter` to sort `.Rbuildignore` (#366).
-   The template `.pre-commit-config.yaml` default to monthly hook
    updates (instead of weekly) to avoid notification triggers and git
    version convolution (#370).
-   The codemeta hook was ported to `language: r` (#350).

**Documentation**

-   Refactor README into new README and a *Get started* vignette (#388).
-   Document advantages of pre-commit in vignette (#379).

**Bug fixes**

-   Don't include `R` as a dependency with
    `snippet_generate("additional-deps-roxygenize")` (#358).
-   `roxygenize` hook now fails if it generates an `.Rd` file that is
    not tracked with version control (#363).
-   Improved compatibility with {renv} (#359, #375, #400).
-   `deps-in-desc` and `parsable-R` can now handle code chunk headers
    with where `purl` or `eval` are not literals like `TRUE`, but
    variables defined elsewhere in code (#361, #382).
-   `deps-in-desc` now prints the original file (not a tempfile) also
    for `.Rmd` and `.Rnw` files.

Thanks to all people who contributed to this release:
[\@assignUser](https://github.com/assignUser),
[\@danhalligan](https://github.com/danhalligan),
[\@gravesti](https://github.com/gravesti),
[\@hadley](https://github.com/hadley),
[\@KyleDCox](https://github.com/KyleDCox),
[\@lorenzwalthert](https://github.com/lorenzwalthert),
[\@lukasfeick-sw](https://github.com/lukasfeick-sw),
[\@MarkMc1089](https://github.com/MarkMc1089),
[\@pat-s](https://github.com/pat-s),
[\@RoyalTS](https://github.com/RoyalTS), and
[\@smingerson](https://github.com/smingerson).

# precommit 0.2.2

This is a maintenance release on the request of CRAN (#337) and to
improve experience with the `language: r` switch conducted in `v0.2.0`.
In particular, note that projects using {renv} and RStudio are not very
compatible with hook versions \> 0.1.3.9014 and `autoupdate()` results
in downgrading the hook versions (#346).

**API Changes**

-   The argument `--no-warn-cache` in the `style-files` and the
    `roxygenize` hook is deprecated and will be removed in a future
    release. Please remove it from your `.pre-commit-config.yaml` (#340.
    #341).

**Other changes**

-   `style-files` hook fails more informatively if required package is
    not listed in `additional_dependencies:` (#333).
-   configure all git operations to use LF (#337).
-   `deps-in-desc` always excludes `README.md` (#336).
-   Document timeout and other problems with pre-commit.ci (#335).
-   simplify `roxygenize` problem handling (#338).
-   More executables on macOS are detected (#344).
-   Only hard dependencies are generated with
    `snippet_generate("additional-deps-roxygenize")` (#344)
-   Fixing more CRAN issues (#348).
-   Use RSMP for all packages (#348).

Thanks to all people who contributed to this release:

[\@lorenzwalthert](https://github.com/lorenzwalthert),
[\@pat-s](https://github.com/pat-s), and
[\@smingerson](https://github.com/smingerson).

# precommit 0.2.0

This version marks the switch to
[`language: r`](https://pre-commit.com/#r) of all existing hooks. This
means two things:

-   creation of isolated pre-commit environments: No more manual
    dependency management for hooks nor conflicts with your global R
    library and more consistent output of hooks from different
    collaborators in a project. Thanks to {renv}'s excellent
    [caching](https://rstudio.github.io/renv/articles/renv.html#cache-1),
    this hardly consumes any space and is fast. This requires the Python
    package `pre-commit >= 2.11.1` (ideally even `>= 2.13.0`). See
    \*Installation/Update\*\* below (#233, #250, #260, #264, #273, #315,
    #313, #308, #301, #300, #295, #285, #328).
-   support for continuous integration via
    [pre-commit.ci](https://pre-commit.ci) and [GitHub
    Actions](https://github.com/pre-commit/action)), that is, running
    the pre-commit hooks as part of a CI pipeline. This means that hook
    passing can be enforced for pull requests, even if the creator did
    not run the hooks locally. Further, the diff from running the hooks
    is committed and pushed back to the remote repository. This may fix
    the failing hook problems in some cases (e.g. `style-files`). See
    `vignette("ci")` for a comparison of the two services (#318).

**API changes**

-   `use_precommit()` gains a new argument `ci` defaulting to `"native"`
    (for [pre-commit](https://pre-commit.ci)) to set up continuous
    integration. Other allowed values are `"gha"` (for\
    [GitHub Actions](https://github.com/pre-commit/action)) or `NULL`
    (for no CI).
-   The new exported function `use_ci(ci = "native")` can be used to set
    up continuous integration for existing repos. The default behavior
    for `ci` for both functions is governed by the R option
    `precommit.ci`.
-   `version_precommit()` and `update_precommit()` are new functions to
    check the version of the installed pre-commit executable and to
    update it (#197).
-   `style-files` hook gains an argument `--cache-root` that is passed
    to `options(styler.cache_root = ...)` (#305).
-   `style-files` hook now supports the full
    [`style_file()`](https://styler.r-lib.org/dev/reference/style_file.html)
    API, e.g. you can supply `--scope=spaces` and similar via `args:` in
    your `.pre-commit-config.yaml`. See the
    [docs](https://lorenzwalthert.github.io/precommit/articles/available-hooks.html#style-files-1)
    for details.
-   `style-files` and `roxygenize` hooks now warn if there is no
    permanent `{R.cache}` cache set up. You can silence the warning with
    the hook argument `--no-warn-cache` (#225).

**Installation/Update**

Please follow the [update
instructions](https://lorenzwalthert.github.io/precommit/dev/#update) or
[installation
instructions](https://lorenzwalthert.github.io/precommit/dev/#installation)
depending on whether or not you previously used pre-commit.

**Major changes**

-   Because hooks run in a virtual environment and the `roxygenize` hook
    runs `pkgload::load_all()`, you need to list all dependencies of
    your package in `additional_dependencies` field in
    `.pre-commit-config.yaml`. You will be prompted to add them if they
    are missing,
    `precommit::snippet_generate("additional-deps-roxygenize")`
    generates the code you can copy/paste (#247, #248, #249).
-   the `parsable-R` hook can now also parse `.Rmd` files (#325).
-   In order to avoid multiple installations of the pre-commit
    framework, a warning is issued if multiple are found so the user can
    remove them (#266, #273, #277, #278).
-   `use_precommit(..., install_hooks = TRUE)` is no longer blocking by
    default. New option `precommit.block_install_hooks` (defaults to
    `FALSE`) governs the behavior (#312).
-   Always sort `inst/WORDLIST` (#303).
-   `.lintr` and `.gitlab-ci.yml` are not ignored in the spell check
    hook (#317).
-   Warnings are no longer promoted to errors in the styler hook, which
    is particularly relevant for the apparently random error
    `Unknown or uninitialised column: text` (#268).
-   `deps-in-desc` now checks `.Rprofile`, `.Rmd` and `.Rnw` files in
    addition to `.R` files (#216).\
-   the lintr and styler hook now also check `.Rmd`, `.Rnw` and
    `.Rprofile` files (#287).
-   `{renv}` infra files are not checked anymore by default in the
    template config files (#237).
-   `.png`, `.jpeg`, `.pdf` and files in `.github/workflows` are no
    longer spell-checked in the template config file (#276).

**Minor changes**

-   rename default branch to *main* (#307).
-   Use dev version of {lintr} to reduce total dependencies from 71 to
    59 that brings down install time.
-   The location of the pre-commit executable is now also recognized on
    Apple Silicon when installed with Homebrew (#240).
-   The location of the pre-commit executable is now also recognized on
    macOS when installed with pip3 and `fs >= 1.5.1` (#330).
-   pinning python version to 3.9 for conda until problems related to
    3.10 are fixed (#310).
-   The cache for the roxygen2 hook is now also invalidated for changes
    in formals if there are no changes in roxygen comments (#214).
-   All sub-patterns in the `exclude:` pattern of the spell check hook
    are now ordered alphabetically (#276).
-   The `deps-in-desc` hook now points to the hook argument
    `--allow_private_imports` when the hook fails due to private imports
    (#254).
-   roxygenize hook is now fully tested (#267).
-   Hook scripts were relocated and R hooks now have a file extension
    (#280).
-   Hook dependency updates are proposed by an automatic monthly pull
    request to `lorenzwalthert/precommit`. This does not affect users
    directly (#430).
-   Updated GitHub Action workflows (#288).
-   Use LF line endings in git config to ensure passing tests on Windows
    for R devel (#321).
-   fixing typos (#289).
-   fix R CMD Check (#284).

A big hand to all the contributors of this release:

[\@adamblake](https://github.com/adamblake),
[\@arbues6](https://github.com/arbues6),
[\@b4D8](https://github.com/b4D8), [\@bart1](https://github.com/bart1),
[\@dhersz](https://github.com/dhersz),
[\@joelnitta](https://github.com/joelnitta),
[\@jucor](https://github.com/jucor),
[\@lorenzwalthert](https://github.com/lorenzwalthert),
[\@lukasfeick-sw](https://github.com/lukasfeick-sw),
[\@MarkMc1089](https://github.com/MarkMc1089),
[\@njtierney](https://github.com/njtierney),
[\@pat-s](https://github.com/pat-s),
[\@pwildenhain](https://github.com/pwildenhain), and
[\@rossdrucker](https://github.com/rossdrucker)

For previous versions of `NEWS.md` with news bullet per patch release,
see the [latest `NEWS.md` before
gathering](https://github.com/lorenzwalthert/precommit/blob/7a8740714ab868d20e981b8b80898d7be050e34e/NEWS.md).

# precommit 0.1.3

This is mainly a CRAN maintenance release because of #201 and includes
some bug fixes and no API changes.

A big hand to all the contributors of this release:
[\@fschoner](https://github.com/fschoner),
[\@krzyslom](https://github.com/krzyslom),
[\@lorenzwalthert](https://github.com/lorenzwalthert),
[\@maurolepore](https://github.com/maurolepore),
[\@pat-s](https://github.com/pat-s), and
[\@zkamvar](https://github.com/zkamvar).

**Minor Changes**

-   install_hooks in `use_precommit()` should now work as expected
    (#185).
-   Switching from Travis to GitHub Actions (#191).
-   `use_precommit()` now writes to the right `.Rbuildignore` when
    `root` is not the current working directory (#188, @krzyslom).
-   Documentation improvements (#179, @maurolepore)
-   `precommit::uninstall_precommit()` now correctly removes
    `^\\.pre-commit-config.yaml$`from `.Rbuildignore` and does not show
    a prompt (#199).

# precommit 0.1.2

Initial CRAN release. See <https://lorenzwalthert.github.io/precommit/>.

# precommit 0.0.0.9049

-   Roxygen hook cache only includes files that are part of the index
    and will hence be able to use the cache in cases it was previously
    invalidated without need (#171).
-   styler hook should fail if styling any file fails (#174).

# precommit 0.0.0.9048

-   Don't allow legacy hooks by default, delete README hook from usethis
    informatively (#167).

# precommit 0.0.0.9046

**Major Changes**

-   `use_precommit()` gains new `install_hooks = TRUE` parameter. Now
    all hook environments defined in yaml config are by default
    installed in advance. (#163)

# precommit 0.0.0.9044

**Breaking Changes**

-   `uninstall_precommit()`'s `scope` argument value `"global"` was
    renamed to `"user"`.

**Major Changes**

-   By default, the spell check hook now exposes a regex pattern in the
    default `.pre-commit-config-config.yaml` for the spell check hook
    for easy manipulation. Also, additional patterns were excluded such
    as `.sh` (#157).

**Minor Changes**

-   `DESCRIPTION` now links the pkgdown website in addition to the
    GitHub repo (#155).
-   `.Renviron`, `.Rrofile`, `.RData`, `.feather` and `.Rds` is now also
    excluded from the spell checking hook.

# precommit 0.0.0.9042

**Breaking Changes**

A major API review was conducted to make the package ready for a CRAN
submission in #152:

-   all functions have the argument `path_root` renamed to `root`.
-   argument `root` now always defaults to `here::here()` for
    consistency.
-   argument `config_source` was renamed to `config_source` in
    `use_precommit_config()` and `use_precommit()`.
-   `use_precommit_config`'s argument `force` gains a default value for
    consistency with `use_config()`.
-   `use_precommit_config`'s argument `verbose` now is in the same
    position as in `use_config()`.

Additional breaking changes are:

-   use env `r-precommit` instead of `r-reticulate` to avoid conflicts
    with other packages commonly installed in `r-reticulate` (#147).
-   the hook `spell-check` does no longer take the hook argument
    `ignore-files` since this was inconsistent with the pre-commit
    framework. To exclude additional files, specify the `exclude:` key
    in your `.pre-commit-config.yaml` file. If you like to keep
    excluding the default files, make sure you include the [default
    regex](https://lorenzwalthert.github.io/precommit/articles/available-hooks.html#spell-check)
    (#153).

# precommit 0.0.0.9040

-   roxygenize hook now only ran when `git diff --cached` contains
    roxygen comments (#151).
-   conda is a suggested dependency now, so those who choose a different
    installation method have a more lightweight dependency graph (#136).
-   Use more thoughtful order for hooks, between pkg and project (#142).

# precommit 0.0.0.9038

Test release process.

# precommit 0.0.0.9030

-   auto-detect pre-commit executable when installed via pip for Linux
    (#120), macOS (#131).
-   auto-detect pre-commit executable when installed via brew for macOS
    (#132).
-   `use_precommit()` gains new argument `config_source` to copy an
    existing config file into the repo at initialization. The argument
    defaults to `options('precommit.config_source')` to make it easy for
    users to use their preferred hooks in every repo they initialize
    (#111).
-   Create `r-precommit` env if not existent before installing into it
    (#114).
-   Unify vignettes on available hooks and arguments (#109).
-   Fail fast when repo is not a git repo (#111).
-   default config file has spell-check activated (#118).
-   also test on macOS (#120).
-   template `.pre-commit-config.yaml` includes hook to check files have
    a EOF blank line (#126).
-   spell-check hook now removes blank lines hand has no blank line at
    EOF (#127).
-   depreciate `path_pre_commit_exec()` in favor of
    `path_precommit_exec()` and adapt internals to replace `pre_commit`
    with `precommit` (#130).
-   more coherent error catching for system calls (#135).
-   internal refactoring (#136).

# precommit 0.0.0.9017

-   **BREAKING:** If you used precommit \< 0.0.0.9017 (and if you choose
    a different installation strategy than
    `precommit::install_precommit()), you can link your existing    executable by setting the R option`precommit.executable\`
    to the path where you stored the pre-commit executable.

-   Adding tools to work with hooks: `install_precommit()`,
    `use_precommit()`, `uninstall_precommit()`, `open_config()` and
    `open_wordlist()` using conda environments on all platforms.

-   Make repo a fully R CMD CHECK compliant R package (includes moving
    hooks to `inst/bin` from `bin`.)

-   renamed repo from pre-commit-hooks to precommit.

-   added pkgdown website, restructured README.
