% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict3d.R
\name{predict3d}
\alias{predict3d}
\title{Draw 3d predict plot using package `rgl`}
\usage{
predict3d(fit, pred = NULL, modx = NULL, mod2 = NULL, dep = NULL,
  xlab = NULL, ylab = NULL, zlab = NULL, width = 640,
  colorn = 20, maxylev = 6, se = FALSE, show.summary = FALSE,
  overlay = NULL, show.error = FALSE, show.legend = FALSE,
  bg = NULL, type = "s", radius = 2, palette = NULL,
  palette.reverse = TRUE, color = "red", show.subtitle = TRUE,
  show.plane = TRUE, plane.color = "steelblue", plane.alpha = 0.5,
  summarymode = 1, ...)
}
\arguments{
\item{fit}{A model object for which prediction is desired.}

\item{pred}{The name of predictor variable}

\item{modx}{Optional. The name of moderator variable}

\item{mod2}{Optional. The name of second moderator variable}

\item{dep}{Optional. The name of dependent variable}

\item{xlab}{x-axis label.}

\item{ylab}{y-axis label.}

\item{zlab}{z-axis label.}

\item{width}{the width of device}

\item{colorn}{An integer giving the desired number of intervals. Non-integer values are rounded down.}

\item{maxylev}{Maximal length of unique values of y axis variable to be treated as a categorical variable.}

\item{se}{Logical. Whether or not show se. Only effective when the y-axis variable is a categorical one.}

\item{show.summary}{Logical. Whether or not show statistical summary}

\item{overlay}{Logical. Whether or not overlay plots}

\item{show.error}{Logical. Whether or not show error}

\item{show.legend}{Logical. Whether or not show legend}

\item{bg}{Character. Background color of plot}

\item{type}{For the default method, a single character indicating the type of item to plot. Supported types are: 'p' for points, 's' for spheres, 'l' for lines, 'h' for line segments from z = 0, and 'n' for nothing. For the mesh3d method, one of 'shade', 'wire', or 'dots'. Partial matching is used.}

\item{radius}{The size of sphere}

\item{palette}{Name of color palette}

\item{palette.reverse}{Logical. Whether or not reverse the palette order}

\item{color}{Default color. Color is used when the palette is NULL}

\item{show.subtitle}{Logical. If true, show regression call as subtitle}

\item{show.plane}{Logical. If true, show regression plane}

\item{plane.color}{Name of color of regression plane}

\item{plane.alpha}{Transparency scale of regression plane}

\item{summarymode}{An integer indicating method of extracting typical value of variables. If 1, typical() is used.If 2, mean() is used.}

\item{...}{additional parameters which will be passed to plot3d}
}
\description{
Draw 3d predict plot using package `rgl`
}
\examples{
fit=lm(mpg~hp*wt,data=mtcars)
predict3d(fit,show.error=TRUE)
fit=lm(log(mpg)~hp*wt,data=mtcars)
predict3d(fit,dep=mpg)
\donttest{
fit=lm(Sepal.Length~Sepal.Width*Species,data=iris)
predict3d(fit,radius=0.05)
require(TH.data)
fit=glm(cens~pnodes*age*horTh,data=GBSG2,family=binomial)
predict3d(fit)
mtcars$engine=ifelse(mtcars$vs==0,"V-shaped","straight")
fit=lm(mpg~wt*engine,data=mtcars)
predict3d(fit,radius=0.5)
fit=loess(mpg~hp*wt,data=mtcars)
predict3d(fit,radius=4)
}
}
