% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{c2_dat2}
\alias{c2_dat2}
\title{Cross-classified data (example 2)}
\format{
A \code{data.frame} with 21 rows and 3 columns:
\describe{
  \item{y_ijk}{observations}
  \item{a}{treatment a}
  \item{b}{treatment b}
}
}
\usage{
c2_dat2
}
\description{
c2_dat2 contains data that was sampled from an unbalanced cross-classified design.
}
\examples{

# loading lme4
library(lme4)

# Fitting a random effects model based on c2_dat_1
fit <- lmer(y_ijk~(1|a)+(1|b)+(1|a:b), c2_dat1)
summary(fit)

# Prediction interval using c2_dat2 as future data
lmer_pi(model=fit, newdat=c2_dat2, alternative="both", nboot=100)

# Please note that nboot was set to 100 in order to increase computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
