% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{bb_dat1}
\alias{bb_dat1}
\title{Beta-binomial data (example 1)}
\format{
A \code{data.frame} with 10 rows and 2 columns:
\describe{
  \item{succ}{number of successes}
  \item{fail}{number of failures}
}
}
\usage{
bb_dat1
}
\description{
This data set contains sampled beta-binomial data from 10 clusters
each of size 50. The data set was sampled with \code{rbbinom(n=10, size=50, prob=0.1, rho=0.06)}.
}
\examples{
# Upper prediction limit for m=3 future number of successes
# that are based on cluster sizes 40, 50, 60 respectively
beta_bin_pi(histdat=bb_dat1, newsize=c(40, 50, 60), alternative="upper", nboot=100)

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
