% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.dhs.prevR.r
\name{import.dhs}
\alias{import.dhs}
\title{Import DHS data.}
\usage{
import.dhs(file.sav, file.dbf)
}
\arguments{
\item{file.sav}{DHS data (one individual per line) in SPSS format (.sav),
downloaded from \url{http://www.dhsprogram.com/}. Could also be directly a data.frame.}

\item{file.dbf}{GPS position of clusters in DATABASE format (.dbf), downloaded from
 \url{http://www.dhsprogram.com/}.  Could also be directly a data.frame.}
}
\description{
This step by step function guides users to import data from a Demographic and Health Survey (DHS)
 and create an object of class \code{\link[=prevR-class]{prevR}}.
}
\note{
If you don't provide the precise path of files, \R will check the working directory
 (see \code{\link[base]{setwd}}). To specify the file path, see \code{\link[base]{file.path}}.

 This function was developed specifically for importing DHS.
 For a generic function for creating an object of class \code{\link[=prevR-class]{prevR}},
 see \code{\link{as.prevR}}.
}
\examples{
\dontrun{
 import.dhs("data.sav", "gps.dbf")
 }
}
\seealso{
\code{\link{as.prevR}}, \code{\link{prevR-class}}.
}
\keyword{manip}

