% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ridit.R
\name{ridit}
\alias{ridit}
\title{Calculate the ridit values for a matrix}
\usage{
ridit(allrawdata)
}
\arguments{
\item{allrawdata}{A data frame where the first column represents IDs.
The IDs uniquely identify each row in the matrix.
The remaining columns contain the numerical data for each ID.}
}
\value{
A data frame with the first column containing IDs (named "Claim.ID")
  and the remaining columns containing ridit scores for each variable.
}
\description{
This function takes a matrix of data and returns the matrix transformed
as ridit values using the method developed by Bross (1958) and modified
by Brockett et al. (2002).
}
\examples{
# Create sample data
test_data <- data.frame(
  ID = c("A", "B", "C", "D", "E"),
  var1 = c(0.9, 0.85, 0.89, 1.0, 0.89),
  var2 = c(0.99, 0.92, 0.90, 1.0, 0.93),
  var3 = c(1.0, 0.99, 0.98, 1.0, 0.99)
)

# Calculate ridit scores
ridit_result <- ridit(test_data)
print(ridit_result)

}
\references{
Bross, I. D. (1958). How to use ridit analysis. Biometrics, 14(1), 18-38.
\doi{10.2307/2527727}

Brockett, P. L., Derrig, R. A., Golden, L. L., Levine, A., & Alpert, M. (2002).
Fraud classification using principal component analysis of RIDITs.
Journal of Risk and Insurance, 69(3), 341-371.
\doi{10.1111/1539-6975.00027}
}
