% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcd-stan-tools.R
\name{pcd_stan_dist_id}
\alias{pcd_stan_dist_id}
\title{Get distribution stan ID by name}
\usage{
pcd_stan_dist_id(name, type = c("delay", "primary"))
}
\arguments{
\item{name}{String. Distribution name or alias}

\item{type}{String. "delay" or "primary" corresponding to the type of
distribution to use as the look up. If delay then \code{\link[=pcd_distributions]{pcd_distributions()}}
is used, if primary then \code{\link[=pcd_primary_distributions]{pcd_primary_distributions()}} is used.}
}
\value{
Numeric distribution ID
}
\description{
Get distribution stan ID by name
}
\examples{
pcd_stan_dist_id("lnorm")
pcd_stan_dist_id("lognormal")
pcd_stan_dist_id("gamma")
pcd_stan_dist_id("weibull")
pcd_stan_dist_id("exp")
pcd_stan_dist_id("unif", type = "primary")
}
\seealso{
Tools for working with package Stan functions
\code{\link{pcd_load_stan_functions}()},
\code{\link{pcd_stan_files}()},
\code{\link{pcd_stan_functions}()},
\code{\link{pcd_stan_path}()}
}
\concept{stantools}
